/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.network.message;

import com.mrbysco.structurecompass.items.StructureCompassItem;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetStructureMessage {
    public Hand hand;
    public ResourceLocation structureLocation;

    public SetStructureMessage(Hand hand, ResourceLocation structureLocation) {
        this.hand = hand;
        this.structureLocation = structureLocation;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.hand == Hand.MAIN_HAND ? 0 : 1);
        buf.func_192572_a(this.structureLocation);
    }

    public static SetStructureMessage decode(PacketBuffer packetBuffer) {
        return new SetStructureMessage(packetBuffer.readInt() == 0 ? Hand.MAIN_HAND : Hand.OFF_HAND, packetBuffer.func_192575_l());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ItemStack stack;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && (stack = ctx.getSender().func_184586_b(this.hand)).func_77973_b() instanceof StructureCompassItem) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("structurecompass:structureName", this.structureLocation.toString());
                stack.func_77982_d(tag);
            }
        });
        ctx.setPacketHandled(true);
    }
}

