/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.util;

import com.mrbysco.structurecompass.config.StructureConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureUtil {
    public static List<ResourceLocation> getAvailableStructureList() {
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        for (Structure structureFeature : ForgeRegistries.STRUCTURE_FEATURES) {
            ResourceLocation location = structureFeature.getRegistryName();
            if (location == null || StructureUtil.isBlacklisted(location.toString()) || structureList.contains(structureFeature.getRegistryName())) continue;
            structureList.add(structureFeature.getRegistryName());
        }
        return structureList;
    }

    public static boolean isBlacklisted(String structureLocation) {
        return !((List)StructureConfig.COMMON.structureBlacklist.get()).isEmpty() && ((List)StructureConfig.COMMON.structureBlacklist.get()).contains(structureLocation);
    }
}

