/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.config;

import com.mrbysco.structurecompass.StructureCompass;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class StructureConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        StructureCompass.LOGGER.debug(StructureCompass.STRUCTURECOMPASS, "Loaded Statues' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.ConfigReloading configEvent) {
        StructureCompass.LOGGER.fatal(Logging.CORE, "Statues' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue compassRange;
        public final ForgeConfigSpec.BooleanValue locateUnexplored;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.compassRange = builder.comment("Sets the range in which the strucute compasses can check for structures [default: 300]").defineInRange("compassRange", 300, 0, Integer.MAX_VALUE);
            this.locateUnexplored = builder.comment("Defines if the structure compass should locate unexplored structures [default: false]").define("locateUnexplored", false);
            builder.pop();
        }
    }
}

