/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.items;

import com.mrbysco.structurecompass.StructureCompass;
import com.mrbysco.structurecompass.config.StructureConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStructureCompass
extends Item {
    private String structure;
    private static final String structure_found = "structurecompass:structureFound";
    private static final String structure_location = "structurecompass:structurePosition";

    public ItemStructureCompass(Item.Properties builder, String structureName) {
        super(builder.func_200916_a(StructureCompass.tabCompass));
        this.structure = structureName;
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity livingBaseIn) {
                double d0;
                LivingEntity entity;
                if (livingBaseIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean livingExists = livingBaseIn != null;
                Object object = entity = livingExists ? livingBaseIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.field_70170_p;
                }
                if (worldIn.field_73011_w.func_76569_d()) {
                    double d1 = livingExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getSpawnToAngle((IWorld)worldIn, (Entity)entity, stack) / 6.2831854820251465;
                    d0 = 0.5 - (d1 - 0.25 - d2);
                } else {
                    d0 = Math.random();
                }
                if (livingExists) {
                    d0 = this.wobble(worldIn, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(World worldIn, double p_185093_2_) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                return MathHelper.func_188209_b((int)(180 + itemFrame.func_174811_aO().func_176736_b() * 90));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getSpawnToAngle(IWorld worldIn, Entity entityIn, ItemStack stack) {
                BlockPos pos = ItemStructureCompass.this.getBlockPos(stack, worldIn.func_201672_e());
                return Math.atan2((double)pos.func_177952_p() - entityIn.field_70161_v, (double)pos.func_177958_n() - entityIn.field_70165_t);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K) {
            this.locateStructure((Entity)playerIn, (ServerWorld)worldIn, stack);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    private void locateStructure(Entity entityIn, ServerWorld worldIn, ItemStack stack) {
        BlockPos structurePos;
        CompoundNBT tag = new CompoundNBT();
        boolean findUnexplored = false;
        if (StructureConfig.COMMON.locateUnexplored.get() != null) {
            findUnexplored = (Boolean)StructureConfig.COMMON.locateUnexplored.get();
        }
        if ((structurePos = worldIn.func_211157_a(this.structure, entityIn.func_180425_c(), 300, findUnexplored)) == null) {
            BlockPos spawnPos = worldIn.func_175694_M();
            tag.func_74757_a(structure_found, false);
            tag.func_74772_a(structure_location, spawnPos.func_218275_a());
        } else {
            tag.func_74757_a(structure_found, true);
            tag.func_74772_a(structure_location, structurePos.func_218275_a());
        }
        stack.func_77982_d(tag);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String structureName = this.structure.replace("_", " ");
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            boolean structureFound = tag.func_74767_n(structure_found);
            if (structureFound) {
                tooltip.add(new TranslationTextComponent("structurecompass.structure.found.tooltip", new Object[]{structureName, structureName}).func_211708_a(TextFormatting.GREEN));
            } else {
                tooltip.add(new TranslationTextComponent("structurecompass.structure.failed.tooltip", new Object[]{structureName}).func_211708_a(TextFormatting.RED));
            }
        } else {
            tooltip.add(new TranslationTextComponent("structurecompass.structure.unset.tooltip", new Object[]{structureName, structureName}).func_211708_a(TextFormatting.GOLD));
        }
    }

    public BlockPos getBlockPos(ItemStack stack, World world) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag.func_74764_b(structure_found)) {
                if (tag.func_74767_n(structure_found)) {
                    Long structureLong = tag.func_74763_f(structure_location);
                    return BlockPos.func_218283_e((long)structureLong);
                }
                return world.func_175694_M();
            }
            return world.func_175694_M();
        }
        return world.func_175694_M();
    }
}

