/*
 * Decompiled with CFR 0.152.
 */
package com.ikerleon.birdwmod.blocks;

import com.ikerleon.birdwmod.Main;
import com.ikerleon.birdwmod.init.BirdwmodBlocks;
import com.ikerleon.birdwmod.init.BirdwmodItems;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRingingNet
extends Block {
    public static final PropertyEnum<EnumBlockType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockType.class);
    public static final PropertyEnum<EnumBlockDirection> DIRECTION = PropertyEnum.func_177709_a((String)"direction", EnumBlockDirection.class);
    AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
    AxisAlignedBB AABB2 = new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0);

    public BlockRingingNet(Material materialIn, String name) {
        super(materialIn);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149711_c(0.5f);
        BirdwmodBlocks.BLOCKS.add(this);
        this.func_149647_a(Main.BIRDWATCHINGMOD);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NORMAL)).func_177226_a(DIRECTION, (Comparable)((Object)EnumBlockDirection.NORTH)));
        BirdwmodItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer.func_174811_aO() == EnumFacing.NORTH || placer.func_174811_aO() == EnumFacing.SOUTH) {
            worldIn.func_175656_a(pos, state.func_177226_a(DIRECTION, (Comparable)((Object)EnumBlockDirection.NORTH)));
        } else {
            worldIn.func_175656_a(pos, state.func_177226_a(DIRECTION, (Comparable)((Object)EnumBlockDirection.EAST)));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, DIRECTION});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(DIRECTION) == EnumBlockDirection.NORTH) {
            return this.AABB;
        }
        return this.AABB2;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(DIRECTION) == EnumBlockDirection.NORTH) {
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177976_e()).func_177229_b(DIRECTION) == EnumBlockDirection.NORTH && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177974_f()).func_177229_b(DIRECTION) == EnumBlockDirection.NORTH) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NET)));
            } else if (worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177974_f()).func_177229_b(DIRECTION) == EnumBlockDirection.NORTH) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.RIGHT)));
            } else if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177976_e()).func_177229_b(DIRECTION) == EnumBlockDirection.NORTH) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.LEFT)));
            } else {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NORMAL)));
            }
        }
        if (state.func_177229_b(DIRECTION) == EnumBlockDirection.EAST) {
            if (worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177968_d()).func_177229_b(DIRECTION) == EnumBlockDirection.EAST && worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177978_c()).func_177229_b(DIRECTION) == EnumBlockDirection.EAST) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NET)));
            } else if (worldIn.func_180495_p(pos.func_177978_c()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177978_c()).func_177229_b(DIRECTION) == EnumBlockDirection.EAST) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.LEFT)));
            } else if (worldIn.func_180495_p(pos.func_177968_d()).func_177230_c() == BirdwmodBlocks.RINGING_NET && worldIn.func_180495_p(pos.func_177968_d()).func_177229_b(DIRECTION) == EnumBlockDirection.EAST) {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.RIGHT)));
            } else {
                worldIn.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NORMAL)));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a(DIRECTION, (Comparable)((Object)EnumBlockDirection.getFront(meta & 1)));
        if ((meta & 2) != 0 && (meta & 4) == 0) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NET));
        } else if ((meta & 2) == 0 && (meta & 4) == 0) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NORMAL));
        } else if ((meta & 2) != 0 && (meta & 4) != 0) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.LEFT));
        } else if ((meta & 2) == 0 && (meta & 4) != 0) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.RIGHT));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumBlockDirection)((Object)state.func_177229_b(DIRECTION))).getIndex();
        switch ((EnumBlockType)((Object)state.func_177229_b(TYPE))) {
            case NORMAL: {
                break;
            }
            case NET: {
                i |= 2;
                break;
            }
            case RIGHT: {
                i |= 4;
                break;
            }
            case LEFT: {
                i |= 6;
            }
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumBlockDirection implements IStringSerializable
    {
        NORTH(0),
        EAST(1);

        private final int index;

        private EnumBlockDirection(int indexIn) {
            this.index = indexIn;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == NORTH ? "north" : "east";
        }

        public static EnumBlockDirection getFront(int index) {
            return index == 0 ? NORTH : EAST;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum EnumBlockType implements IStringSerializable
    {
        NORMAL(0),
        RIGHT(1),
        LEFT(2),
        NET(3);

        private final int index;

        private EnumBlockType(int indexIn) {
            this.index = indexIn;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            if (this == NORMAL) {
                return "normal";
            }
            if (this == RIGHT) {
                return "right";
            }
            if (this == LEFT) {
                return "left";
            }
            return "net";
        }

        public static EnumBlockType getFront(int index) {
            switch (index) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return RIGHT;
                }
                case 2: {
                    return LEFT;
                }
                case 3: {
                    return NET;
                }
            }
            return NORMAL;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

