/*
 * Decompiled with CFR 0.152.
 */
package com.ikerleon.birdwmod.client.render.europe;

import com.ikerleon.birdwmod.client.render.RenderBirdBase;
import com.ikerleon.birdwmod.entity.europe.EntityStellersEider;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFAnimator;
import net.soggymustache.bookworm.client.model.ModelCMF;

public class RenderStellersEider
extends RenderBirdBase<EntityStellersEider> {
    public static final ModelCMF STELLERS_EIDER = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/stellers_eider/stellers_eider.bkm"));
    public static final ModelCMF STELLERS_EIDER_SWIMMING = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/stellers_eider/stellers_eider_swimming.bkm"));
    public static final ModelCMF STELLERS_EIDER_FLYING = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/stellers_eider/stellers_eider_flying.bkm"));
    public static final ModelCMF STELLERS_EIDER_SLEEPING = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/stellers_eider/stellers_eider_sleeping.bkm"));
    public static final ResourceLocation TEXTUREMALE = new ResourceLocation("birdwmod:textures/entity/europe/stellerseidermale.png");
    public static final ResourceLocation TEXTUREFEMALE = new ResourceLocation("birdwmod:textures/entity/europe/stellerseiderfemale.png");
    public static final ResourceLocation TEXTURECHICK = new ResourceLocation("birdwmod:textures/entity/europe/stellerseider_chick.png");
    public static final ResourceLocation TEXTUREBLINK = new ResourceLocation("birdwmod:textures/entity/europe/stellerseider_sleeping.png");
    private final ResourceLocation EIDER_RING = new ResourceLocation("birdwmod:textures/entity/rings/eider_ring.png");

    public RenderStellersEider(RenderManager manager) {
        super(manager, (ModelBase)STELLERS_EIDER, 0.15f);
        STELLERS_EIDER.setAnimator(x$0 -> new StellersEiderAnimator((ModelCMF)x$0));
    }

    protected void preRenderCallback(EntityStellersEider entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            float scaleFactor = 0.3f;
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        } else {
            float scaleFactor = 0.6f;
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        }
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityStellersEider entity) {
        return TEXTUREBLINK;
    }

    @Override
    public ResourceLocation getRingTexture(EntityStellersEider entity) {
        return this.EIDER_RING;
    }

    protected ResourceLocation getEntityTexture(EntityStellersEider entity) {
        if (entity.func_70631_g_()) {
            return TEXTURECHICK;
        }
        if (entity.getGender() == 0) {
            return TEXTUREMALE;
        }
        return TEXTUREFEMALE;
    }

    private class StellersEiderAnimator
    extends CMFAnimator {
        private final BookwormModelRenderer rightleg;
        private final BookwormModelRenderer leftleg;
        private final BookwormModelRenderer neck;
        private final BookwormModelRenderer body2;
        private final BookwormModelRenderer head;
        private final BookwormModelRenderer rightwing;
        private final BookwormModelRenderer leftwing;
        private final BookwormModelRenderer rightwing2;
        private final BookwormModelRenderer leftwing2;

        public StellersEiderAnimator(ModelCMF model) {
            super(model);
            this.rightleg = this.getModel().getPartByName("rightleg");
            this.leftleg = this.getModel().getPartByName("leftleg");
            this.neck = this.getModel().getPartByName("neck");
            this.body2 = this.getModel().getPartByName("body2");
            this.head = this.getModel().getPartByName("head");
            this.rightwing = this.getModel().getPartByName("rightwing");
            this.leftwing = this.getModel().getPartByName("leftwing");
            this.rightwing2 = this.getModel().getPartByName("rightwing2");
            this.leftwing2 = this.getModel().getPartByName("leftwing2");
        }

        public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
            super.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
            this.getModel().reset();
            BlockPos pos = new BlockPos(entityIn.field_70165_t, entityIn.field_70163_u - 0.2, entityIn.field_70161_v);
            if (entityIn instanceof EntityStellersEider) {
                EntityStellersEider eider = (EntityStellersEider)entityIn;
                float globalSpeed = 1.5f;
                float globalDegree = 1.25f;
                if (eider.isSleeping() && eider.field_70122_E) {
                    this.getModel().interpolateToPose((BookwormModelBase)STELLERS_EIDER_SLEEPING, eider.timer);
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.05f * 1.0f * 0.5f + 0.125f;
                    this.head.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.2f)) * 0.06f * 1.0f * 0.5f + 1.4f;
                    this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f;
                    this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f;
                } else {
                    this.rightleg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f * globalSpeed)) * 0.5f * globalDegree * 1.0f * limbSwingAmount - 2.0f;
                    this.leftleg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f * globalSpeed)) * 0.5f * globalDegree * -1.0f * limbSwingAmount - 2.0f;
                    this.neck.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.8f * globalSpeed)) * 0.05f * globalDegree * -1.0f * limbSwingAmount + 2.625f;
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.8f * globalSpeed)) * 0.1f * globalDegree * -1.0f * limbSwingAmount + 0.0f;
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.05f * 1.0f * 0.5f + 0.125f;
                    this.head.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.2f)) * 0.06f * 1.0f * 0.5f + 1.4f;
                    this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f;
                    this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f;
                    if (!(eider.field_70122_E || eider.func_70090_H() || eider.func_70631_g_() || entityIn.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h)) {
                        this.getModel().interpolateToPose((BookwormModelBase)STELLERS_EIDER_FLYING, eider.timer);
                        this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.6f * globalSpeed + 0.0f)) * 0.2f * globalDegree * -1.0f * 0.5f + 1.25f;
                        this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.6f * globalSpeed + 0.0f)) * 0.2f * globalDegree * -1.0f * 0.5f + 1.25f;
                        this.rightwing.field_78796_g = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * -1.0f * 0.5f - 1.5f;
                        this.leftwing.field_78796_g = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * 1.0f * 0.5f + 1.5f;
                        this.rightwing2.field_78808_h = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * 1.0f * 0.5f + 0.0f;
                        this.leftwing2.field_78808_h = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * -1.0f * 0.5f + 0.0f;
                    } else if (eider.func_70090_H() || entityIn.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                        this.getModel().interpolateToPose((BookwormModelBase)STELLERS_EIDER_SWIMMING, eider.timer);
                        this.rightleg.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.2f * globalSpeed + 0.0f)) * 0.5f * globalDegree * -1.0f * 0.5f - 2.0f;
                        this.leftleg.field_78795_f = MathHelper.func_76134_b((float)((float)eider.field_70173_aa * 0.2f * globalSpeed + 0.0f)) * 0.5f * globalDegree * 1.0f * 0.5f + -2.0f;
                    }
                }
            }
        }
    }
}

