/*
 * Decompiled with CFR 0.152.
 */
package com.ikerleon.birdwmod.client.render.jungle;

import com.ikerleon.birdwmod.client.render.RenderBirdBase;
import com.ikerleon.birdwmod.entity.jungle.EntityHoatzin;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.soggymustache.bookworm.client.animation.part.BookwormModelBase;
import net.soggymustache.bookworm.client.animation.part.BookwormModelRenderer;
import net.soggymustache.bookworm.client.model.CMFAnimator;
import net.soggymustache.bookworm.client.model.ModelCMF;

public class RenderHoatzin
extends RenderBirdBase<EntityHoatzin> {
    public static final ModelCMF HOATZIN = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/hoatzin/hoatzin.bkm"));
    public static final ModelCMF HOATZIN_FLYING = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/hoatzin/hoatzin_flying.bkm"));
    public static final ModelCMF HOATZIN_SLEEPING = new ModelCMF(new ResourceLocation("birdwmod", "models/entity/hoatzin/hoatzin_sleeping.bkm"));
    public static final ResourceLocation TEXTURE = new ResourceLocation("birdwmod:textures/entity/jungle/hoatzin.png");
    public static final ResourceLocation TEXTURECHICK = new ResourceLocation("birdwmod:textures/entity/jungle/hoatzin_chick.png");
    public static final ResourceLocation TEXTUREBLINK = new ResourceLocation("birdwmod:textures/entity/jungle/hoatzin_sleeping.png");
    private final ResourceLocation HOATZIN_RING = new ResourceLocation("birdwmod:textures/entity/rings/hoatzin_ring.png");

    public RenderHoatzin(RenderManager manager) {
        super(manager, (ModelBase)HOATZIN, 0.3f);
        HOATZIN.setAnimator(x$0 -> new HoatzinAnimator((ModelCMF)x$0));
    }

    protected void preRenderCallback(EntityHoatzin entitylivingbaseIn, float partialTickTime) {
        if (entitylivingbaseIn.func_70631_g_()) {
            float scaleFactor = 0.3f;
            GlStateManager.func_179137_b((double)0.0, (double)-0.075, (double)0.0);
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        } else {
            float scaleFactor = 0.5f;
            GlStateManager.func_179137_b((double)0.0, (double)-0.075, (double)0.0);
            GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
        }
    }

    @Override
    public ResourceLocation getBlinkTexture(EntityHoatzin entity) {
        return TEXTUREBLINK;
    }

    @Override
    public ResourceLocation getRingTexture(EntityHoatzin entity) {
        return this.HOATZIN_RING;
    }

    protected ResourceLocation getEntityTexture(EntityHoatzin entity) {
        if (entity.func_70631_g_()) {
            return TEXTURECHICK;
        }
        return this.getTextureOfVar(entity.getVariant());
    }

    public ResourceLocation getTextureOfVar(int variant) {
        switch (variant) {
            default: 
        }
        return TEXTURE;
    }

    private class HoatzinAnimator
    extends CMFAnimator {
        private final BookwormModelRenderer rightleg;
        private final BookwormModelRenderer leftleg;
        private final BookwormModelRenderer body2;
        private final BookwormModelRenderer necktop;
        private final BookwormModelRenderer head;
        private final BookwormModelRenderer rightwing;
        private final BookwormModelRenderer leftwing;
        private final BookwormModelRenderer rightwing2;
        private final BookwormModelRenderer leftwing2;

        public HoatzinAnimator(ModelCMF model) {
            super(model);
            this.rightleg = this.getModel().getPartByName("RlegBase");
            this.leftleg = this.getModel().getPartByName("LLeftBase");
            this.body2 = this.getModel().getPartByName("TailBase");
            this.necktop = this.getModel().getPartByName("Neck2");
            this.head = this.getModel().getPartByName("Head");
            this.rightwing = this.getModel().getPartByName("RWing1");
            this.leftwing = this.getModel().getPartByName("LWing1");
            this.rightwing2 = this.getModel().getPartByName("RWing2");
            this.leftwing2 = this.getModel().getPartByName("LWing2");
        }

        public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
            super.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
            this.getModel().reset();
            if (entityIn instanceof EntityHoatzin) {
                EntityHoatzin hoatzin = (EntityHoatzin)entityIn;
                float globalSpeed = 1.5f;
                float globalDegree = 1.25f;
                if (hoatzin.isSleeping() && hoatzin.field_70122_E) {
                    this.getModel().interpolateToPose((BookwormModelBase)HOATZIN_SLEEPING, hoatzin.timer);
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.05f * 1.0f * 0.5f - 0.174533f;
                    this.head.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.2f)) * 0.06f * 1.0f * 0.5f + 0.2181662f;
                    this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f - 1.48353f;
                    this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f - 1.48353f;
                } else {
                    this.rightleg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f * globalSpeed)) * 0.5f * globalDegree * 1.0f * limbSwingAmount + 0.375f - 0.872665f;
                    this.leftleg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.5f * globalSpeed)) * 0.5f * globalDegree * -1.0f * limbSwingAmount + 0.375f - 0.872665f;
                    this.head.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.8f * globalSpeed)) * 0.05f * globalDegree * -1.0f * limbSwingAmount + 0.2181662f;
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.8f * globalSpeed)) * 0.1f * globalDegree * -1.0f * limbSwingAmount - 0.174533f;
                    this.body2.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.05f * 1.0f * 0.5f - 0.174533f;
                    this.head.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.2f)) * 0.06f * 1.0f * 0.5f + 0.2181662f;
                    this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f - 1.48353f;
                    this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.17f)) * 0.03f * -1.0f * 0.5f - 1.48353f;
                    if (!(hoatzin.field_70122_E || hoatzin.func_70090_H() || hoatzin.func_70631_g_())) {
                        this.getModel().interpolateToPose((BookwormModelBase)HOATZIN_FLYING, hoatzin.timer);
                        this.rightwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.6f * globalSpeed + 0.0f)) * 0.2f * globalDegree * -1.0f * 0.5f - (float)Math.toRadians(165.0);
                        this.leftwing.field_78795_f = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.6f * globalSpeed + 0.0f)) * 0.2f * globalDegree * -1.0f * 0.5f - (float)Math.toRadians(165.0);
                        this.rightwing.field_78796_g = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * -1.0f * 0.5f + (float)Math.toRadians(85.0);
                        this.leftwing.field_78796_g = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * 1.0f * 0.5f - (float)Math.toRadians(85.0);
                        this.rightwing2.field_78796_g = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * 1.0f * 0.5f + 0.0f;
                        this.leftwing2.field_78796_g = MathHelper.func_76134_b((float)((float)hoatzin.field_70173_aa * 0.3f * globalSpeed + 0.0f)) * 0.4f * globalDegree * -1.0f * 0.5f + 0.0f;
                    }
                }
            }
        }
    }
}

