/*
 * Decompiled with CFR 0.152.
 */
package com.ikerleon.birdwmod.entity;

import com.ikerleon.birdwmod.blocks.BlockRingingNet;
import com.ikerleon.birdwmod.entity.ai.EntityAIEatFromFeeders;
import com.ikerleon.birdwmod.entity.ai.EntityAIWanderAvoidWaterFlying;
import com.ikerleon.birdwmod.entity.move.EntityFlyHelper;
import com.ikerleon.birdwmod.init.BirdwmodBlocks;
import com.ikerleon.birdwmod.init.BirdwmodItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.soggymustache.bookworm.util.BookwormRandom;

public abstract class EntityBird
extends EntityAnimal
implements EntityFlying {
    protected static final DataParameter<Integer> GENDER = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RING_COLOR = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> RINGED = EntityDataManager.func_187226_a(EntityBird.class, (DataSerializer)DataSerializers.field_187198_h);
    public float timer;
    public int timeUntilNextFeather;
    protected boolean blink = false;
    private byte nextBlink = 0;
    private byte blinkTime = 0;
    private byte blinkSec = 0;
    private BookwormRandom rando = new BookwormRandom();
    protected EntityAIWanderAvoidWaterFlying WanderFlying;
    protected EntityAIWanderAvoidWater Wander;
    private EntityAIAvoidEntity<EntityPlayer> avoidEntity = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 7.0f, 0.8, 1.33);

    public EntityBird(World worldIn) {
        super(worldIn);
        this.setGender(this.func_70681_au().nextInt(2));
        this.setVariant(this.func_70681_au().nextInt(this.setBirdVariants()));
        this.timeUntilNextFeather = this.field_70146_Z.nextInt(10000) + 10000;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEatFromFeeders(this));
        this.field_70714_bg.func_75776_a(4, this.avoidEntity);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        if (!this.isAquatic()) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        } else {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        }
    }

    public float func_70047_e() {
        return this.field_70131_O - this.field_70131_O * 0.1f;
    }

    protected void func_184651_r() {
        this.Wander = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.WanderFlying = new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 1.0);
        super.func_184651_r();
        if (this.func_70631_g_()) {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.Wander);
        } else {
            this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.Wander);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.WanderFlying);
        }
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENDER, (Object)0);
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(RING_COLOR, (Object)EnumDyeColor.GRAY.func_176767_b());
        this.field_70180_af.func_187214_a(RINGED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("Gender", this.getGender());
        tagCompound.func_74768_a("Variant", this.getVariant());
        tagCompound.func_74757_a("Sleeping", this.isSleeping());
        tagCompound.func_74774_a("CollarColor", (byte)this.getRingColor().func_176767_b());
        tagCompound.func_74757_a("Ringed", this.hasBeenRinged());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setGender(tagCompound.func_74762_e("Gender"));
        this.setVariant(tagCompound.func_74762_e("Variant"));
        this.setSleeping(tagCompound.func_74767_n("Sleeping"));
        this.setRinged(tagCompound.func_74767_n("Ringed"));
        if (tagCompound.func_150297_b("CollarColor", 99)) {
            this.setRingColor(EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("CollarColor")));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.19);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        if (this.func_70631_g_()) {
            return super.func_175447_b(worldIn);
        }
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer)) {
            super.func_82167_n(entityIn);
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.isInNet()) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177229_b(BlockRingingNet.DIRECTION) == BlockRingingNet.EnumBlockDirection.NORTH) {
                this.field_70161_v = this.field_70161_v - this.field_70161_v % 1.0 + 0.5;
            } else {
                this.field_70165_t = this.field_70165_t - this.field_70165_t % 1.0 + 0.5;
            }
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else {
            super.func_70091_d(type, x, y, z);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isInNet()) {
            this.field_70143_R = 0.0f;
            this.field_70122_E = true;
        }
        this.timer = !this.field_70122_E && !this.func_70090_H() || this.isAquatic() && this.func_70090_H() || this.isSleeping() ? (this.timer += 0.05f) : 0.0f;
        if (!this.isSleeping()) {
            if (this.field_70146_Z.nextInt(5) == 3) {
                this.blinkSec = (byte)(this.rando.nextByte((byte)50) + 30);
            }
            if (!this.blink) {
                this.nextBlink = (byte)(this.nextBlink + 1);
            }
            if (this.nextBlink >= this.blinkSec) {
                this.blink = true;
                this.nextBlink = 0;
            }
            if (this.blink) {
                this.blinkTime = (byte)(this.blinkTime + 1);
            }
            if (this.blinkTime >= 3) {
                this.blink = false;
                this.blinkTime = 0;
            }
        }
        if (this.hasBeenRinged() && !this.func_104002_bU()) {
            this.func_110163_bv();
        }
    }

    protected void func_70623_bb() {
        super.func_70623_bb();
    }

    public abstract boolean goesToFeeders();

    public abstract boolean isAquatic();

    protected boolean func_70692_ba() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * 4.0) * d0;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        EnumDyeColor enumdyecolor;
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == BirdwmodItems.RING) {
            if (!this.hasBeenRinged()) {
                this.setRinged(true);
                ++player.field_71068_ca;
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151100_aR && this.hasBeenRinged() && (enumdyecolor = EnumDyeColor.func_176766_a((int)itemstack.func_77960_j())) != this.getRingColor()) {
            this.setRingColor(enumdyecolor);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean isSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean value) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)value);
    }

    public boolean isInNet() {
        Block block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_177230_c();
        return block == BirdwmodBlocks.RINGING_NET;
    }

    public boolean func_70610_aX() {
        if (this.field_70122_E) {
            return super.func_70610_aX() || this.isSleeping();
        }
        return super.func_70610_aX();
    }

    public boolean getBlinking() {
        return this.blink;
    }

    public int getGender() {
        return (Integer)this.field_70180_af.func_187225_a(GENDER);
    }

    public void setGender(int value) {
        this.field_70180_af.func_187227_b(GENDER, (Object)value);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int value) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)value);
    }

    public EnumDyeColor getRingColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(RING_COLOR) & 0xF));
    }

    public void setRingColor(EnumDyeColor collarcolor) {
        this.field_70180_af.func_187227_b(RING_COLOR, (Object)collarcolor.func_176767_b());
    }

    public boolean hasBeenRinged() {
        return (Boolean)this.field_70180_af.func_187225_a(RINGED);
    }

    public void setRinged(boolean value) {
        this.field_70180_af.func_187227_b(RINGED, (Object)value);
    }

    public abstract int setBirdVariants();
}

