/*
 * Decompiled with CFR 0.152.
 */
package com.ikerleon.birdwmod.entity.ai;

import com.ikerleon.birdwmod.blocks.BlockBirdfeeder;
import com.ikerleon.birdwmod.entity.EntityBird;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;

public class EntityAIEatFromFeeders
extends EntityAIBase {
    private static final int RADIUS = 8;
    private BlockPos targetBlock = null;
    private final EntityBird entity;
    private final BlockSorter targetSorter;
    private int feedingTicks;

    public EntityAIEatFromFeeders(EntityBird entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        if (!this.entity.isSleeping()) {
            return this.entity.goesToFeeders() && !this.entity.func_70631_g_();
        }
        return false;
    }

    private void resetTarget() {
        this.targetBlock = null;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.func_180425_c().func_177982_a(-8, -8, -8), (BlockPos)this.entity.func_180425_c().func_177982_a(8, 8, 8))) {
            Block block = this.entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (!(block instanceof BlockBirdfeeder)) continue;
            BlockBirdfeeder feeder = (BlockBirdfeeder)block;
            if (!((Boolean)this.entity.field_70170_p.func_180495_p(pos).func_177229_b((IProperty)BlockBirdfeeder.FILLED)).booleanValue()) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    public boolean func_75253_b() {
        if (this.entity.isSleeping()) {
            return false;
        }
        return !this.entity.func_70610_aX() && this.targetBlock != null && this.entity.field_70170_p.func_180495_p(this.targetBlock).func_177230_c() instanceof BlockBirdfeeder;
    }

    public void func_75251_c() {
        this.targetBlock = null;
        this.resetTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75246_d() {
        if (this.targetBlock == null) {
            this.func_75251_c();
            return;
        }
        Block entity = this.entity.field_70170_p.func_180495_p(this.targetBlock).func_177230_c();
        this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n(), (double)(this.targetBlock.func_177956_o() + 1), (double)this.targetBlock.func_177952_p(), 0.75);
        if (!(entity instanceof BlockBirdfeeder)) return;
        BlockBirdfeeder feeder = (BlockBirdfeeder)entity;
        double distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
        if (!(distance < Math.max(this.entity.func_174813_aQ().func_72320_b() * 2.5, 2.5))) {
            this.feedingTicks = 0;
            this.targetBlock = null;
            this.func_75251_c();
            return;
        }
        if (this.feedingTicks < 30 && ((Boolean)this.entity.field_70170_p.func_180495_p(this.targetBlock).func_177229_b((IProperty)BlockBirdfeeder.FILLED)).booleanValue()) {
            ++this.feedingTicks;
            this.entity.func_70606_j(Math.min(this.entity.func_110138_aP(), (float)((int)(this.entity.func_110143_aJ() + (float)(this.feedingTicks / 4)))));
            return;
        }
        this.feedingTicks = 0;
        this.targetBlock = null;
        this.func_75251_c();
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

