/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.tileentity;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import trapcraft.block.BlockFan;

public class TileEntityFan
extends TileEntity
implements ITickable {
    public float speed = 1.0f;
    public double extraRange = 0.0;

    public void func_73660_a() {
        if (!((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFan.POWERED)).booleanValue()) {
            return;
        }
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFan.FACING);
        if (this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            TileEntityFan.spawnParticles(this.field_145850_b, this.field_174879_c);
        }
        FMLLog.info((String)"%s", (Object[])new Object[]{this.field_145850_b});
        List list = this.field_145850_b.func_72872_a(Entity.class, this.getDirection());
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                double d = 0.05;
                double d1 = 0.3;
                d *= (double)this.speed;
                if (entity instanceof EntityItem) {
                    d1 *= 1.8;
                    d *= 1.3;
                }
                if (entity instanceof EntityMinecart) {
                    d *= 0.5;
                }
                if (entity instanceof EntityFallingBlock && facing == EnumFacing.UP) {
                    d = 0.0;
                }
                if (!this.isPathClear(entity, facing)) continue;
                if (facing == EnumFacing.DOWN && entity.field_70181_x > -d1) {
                    entity.field_70181_x += -d;
                }
                if (facing == EnumFacing.UP && entity.field_70181_x < d1 * 0.5) {
                    entity.field_70181_x += d;
                }
                if (facing == EnumFacing.NORTH && entity.field_70179_y > -d1) {
                    entity.field_70179_y += -d;
                }
                if (facing == EnumFacing.SOUTH && entity.field_70179_y < d1) {
                    entity.field_70179_y += d;
                }
                if (facing == EnumFacing.WEST && entity.field_70159_w > -d1) {
                    entity.field_70159_w += -d;
                }
                if (facing != EnumFacing.EAST || !(entity.field_70159_w < d1)) continue;
                entity.field_70159_w += d;
            }
        }
    }

    public boolean isPathClear(Entity entity, EnumFacing facing) {
        int x = facing.func_82601_c() * (MathHelper.func_76128_c((double)entity.field_70165_t) - this.field_174879_c.func_177958_n());
        int y = facing.func_96559_d() * (MathHelper.func_76128_c((double)entity.field_70163_u) - this.field_174879_c.func_177956_o());
        int z = facing.func_82599_e() * (MathHelper.func_76128_c((double)entity.field_70161_v) - this.field_174879_c.func_177952_p());
        boolean flag = true;
        for (int l2 = 1; l2 < Math.abs(x + y + z); ++l2) {
            if (!this.field_145850_b.func_175665_u(this.field_174879_c.func_177967_a(facing, l2))) continue;
            flag = false;
        }
        return flag;
    }

    public String getSliderDisplay() {
        float f = this.speed;
        f *= 100.0f;
        f = (float)Math.round(f) / 100.0f;
        return String.valueOf(f);
    }

    public AxisAlignedBB getDirection() {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFan.FACING);
        BlockPos endPos = this.field_174879_c.func_177967_a(facing, MathHelper.func_76128_c((double)(5.0 + this.extraRange)));
        if (facing == EnumFacing.WEST) {
            endPos = endPos.func_177982_a(0, 1, 1);
        } else if (facing == EnumFacing.NORTH) {
            endPos = endPos.func_177982_a(1, 1, 0);
        }
        if (facing == EnumFacing.EAST) {
            endPos = endPos.func_177982_a(1, 1, 1);
        } else if (facing == EnumFacing.SOUTH) {
            endPos = endPos.func_177982_a(1, 1, 1);
        }
        if (facing == EnumFacing.UP) {
            endPos = endPos.func_177982_a(1, 1, 1);
        } else if (facing == EnumFacing.DOWN) {
            endPos = endPos.func_177982_a(1, 0, 1);
        }
        return new AxisAlignedBB(this.field_174879_c, endPos);
    }

    public static void spawnParticles(World world, BlockPos pos) {
        double var7 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
        double var9 = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
        double var11 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
        double velX = 0.0;
        double velY = 0.0;
        double velZ = 0.0;
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockFan.FACING);
        switch (facing) {
            case DOWN: {
                velY = -((double)(world.field_73012_v.nextFloat() * 0.6f));
                break;
            }
            case UP: {
                velY = world.field_73012_v.nextFloat() * 0.6f;
                break;
            }
            case NORTH: {
                velZ = -((double)(world.field_73012_v.nextFloat() * 0.6f));
                break;
            }
            case SOUTH: {
                velZ = world.field_73012_v.nextFloat() * 0.6f;
                break;
            }
            case WEST: {
                velX = -((double)(world.field_73012_v.nextFloat() * 0.6f));
                break;
            }
            case EAST: {
                velX = world.field_73012_v.nextFloat() * 0.6f;
            }
        }
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var7, var9, var11, velX, velY, velZ, new int[0]);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.speed = compound.func_74760_g("speed");
        this.extraRange = compound.func_74769_h("extraRange");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("speed", this.speed);
        compound.func_74780_a("extraRange", this.extraRange);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        return this.func_189515_b(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }
}

