/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpikes
extends Block {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);

    public BlockSpikes() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!this.canBlockStay((World)world, pos)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
        return blockstate.func_177230_c().isSideSolid(blockstate, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity.field_70143_R >= 5.0f) {
            entity.func_70097_a(DamageSource.field_76379_h, 20.0f);
            return;
        }
        double motionX = entity.field_70159_w;
        double motionY = entity.field_70181_x;
        double motionZ = entity.field_70179_y;
        int damageTodo = (int)((motionX + motionY + motionZ) / 1.5);
        entity.func_70097_a(DamageSource.field_76377_j, (float)(2 + damageTodo));
    }
}

