/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import trapcraft.TrapcraftMod;
import trapcraft.block.BlockBearTrap;
import trapcraft.block.BlockFan;
import trapcraft.block.BlockGrassCovering;
import trapcraft.block.BlockIgniter;
import trapcraft.block.BlockMagneticChest;
import trapcraft.block.BlockSpikes;
import trapcraft.client.renders.TileEntityItemStackMagneticChestRenderer;
import trapcraft.tileentity.TileEntityBearTrap;
import trapcraft.tileentity.TileEntityFan;
import trapcraft.tileentity.TileEntityIgniter;
import trapcraft.tileentity.TileEntityMagneticChest;

public class ModBlocks {
    @ObjectHolder(value="trapcraft:fan")
    public static Block FAN;
    @ObjectHolder(value="trapcraft:magnetic_chest")
    public static Block MAGNETIC_CHEST;
    @ObjectHolder(value="trapcraft:grass_covering")
    public static Block GRASS_COVERING;
    @ObjectHolder(value="trapcraft:bear_trap")
    public static Block BEAR_TRAP;
    @ObjectHolder(value="trapcraft:spikes")
    public static Block SPIKES;
    @ObjectHolder(value="trapcraft:igniter")
    public static Block IGNITER;
    @ObjectHolder(value="trapcraft:magnetic_chest")
    public static TileEntityType<TileEntityMagneticChest> TILE_MAGNETIC_CHEST;
    @ObjectHolder(value="trapcraft:fan")
    public static TileEntityType<TileEntityFan> TILE_FAN;
    @ObjectHolder(value="trapcraft:bear_trap")
    public static TileEntityType<TileEntityBearTrap> TILE_BEAR_TRAP;
    @ObjectHolder(value="trapcraft:igniter")
    public static TileEntityType<TileEntityIgniter> TILE_IGNITER;

    @Mod.EventBusSubscriber(modid="trapcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            blockRegistry.register(new BlockFan().setRegistryName("trapcraft:fan"));
            blockRegistry.register(new BlockMagneticChest().setRegistryName("trapcraft:magnetic_chest"));
            blockRegistry.register(new BlockGrassCovering().setRegistryName("trapcraft:grass_covering"));
            blockRegistry.register(new BlockBearTrap().setRegistryName("trapcraft:bear_trap"));
            blockRegistry.register(new BlockSpikes().setRegistryName("trapcraft:spikes"));
            blockRegistry.register(new BlockIgniter().setRegistryName("trapcraft:igniter"));
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            IForgeRegistry tileRegistry = event.getRegistry();
            tileRegistry.register(Registration.register("trapcraft:magnetic_chest", TileEntityType.Builder.func_200963_a(TileEntityMagneticChest::new)).setRegistryName("trapcraft:magnetic_chest"));
            tileRegistry.register(Registration.register("trapcraft:fan", TileEntityType.Builder.func_200963_a(TileEntityFan::new)).setRegistryName("trapcraft:fan"));
            tileRegistry.register(Registration.register("trapcraft:bear_trap", TileEntityType.Builder.func_200963_a(TileEntityBearTrap::new)).setRegistryName("trapcraft:bear_trap"));
            tileRegistry.register(Registration.register("trapcraft:igniter", TileEntityType.Builder.func_200963_a(TileEntityIgniter::new)).setRegistryName("trapcraft:igniter"));
        }

        public static <T extends TileEntity> TileEntityType<T> register(String id, TileEntityType.Builder<T> builder) {
            Type type = null;
            try {
                type = DataFixesManager.func_210901_a().getSchema(DataFixUtils.makeKey((int)1631)).getChoiceType(TypeReferences.field_211294_j, id);
            }
            catch (IllegalArgumentException illegalstateexception) {
                if (SharedConstants.field_206244_b) {
                    throw illegalstateexception;
                }
                TrapcraftMod.LOGGER.warn("No data fixer registered for block entity {}", (Object)id);
            }
            TileEntityType tileentitytype = builder.func_206865_a(type);
            return tileentitytype;
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            itemRegistry.register(new ItemBlock(MAGNETIC_CHEST, new Item.Properties().func_200916_a(ItemGroup.field_78028_d).setTEISR(() -> TileEntityItemStackMagneticChestRenderer::new)).setRegistryName(MAGNETIC_CHEST.getRegistryName()));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeItemBlock(GRASS_COVERING));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeItemBlock(FAN));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeItemBlock(BEAR_TRAP));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeItemBlock(SPIKES));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeItemBlock(IGNITER));
        }

        private static ItemBlock makeItemBlock(Block block) {
            return Registration.makeItemBlock(block, ItemGroup.field_78028_d);
        }

        private static ItemBlock makeItemBlock(Block block, ItemGroup group) {
            return (ItemBlock)new ItemBlock(block, new Item.Properties().func_200916_a(group)).setRegistryName(block.getRegistryName());
        }
    }
}

