/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import trapcraft.tileentity.TileEntityIgniter;

public class BlockIgniter
extends BlockContainer {
    public static final DirectionProperty FACING = BlockDirectional.field_176387_N;
    private Random rand = new Random();

    public BlockIgniter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.5f, 2.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.WEST));
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntityIgniter tileentityigniter = (TileEntityIgniter)worldIn.func_175625_s(pos);
        if (tileentityigniter != null && playerIn instanceof EntityPlayerMP && !(playerIn instanceof FakePlayer)) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)playerIn;
            NetworkHooks.openGui((EntityPlayerMP)entityPlayerMP, (IInteractionObject)tileentityigniter, buf -> buf.func_179255_a(pos));
        }
        return true;
    }

    public void onNeighborChange(IBlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.updateIgniterState((World)world, pos);
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public void updateIgniterState(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TileEntityIgniter igniter = (TileEntityIgniter)world.func_175625_s(pos);
        boolean flag = world.func_175640_z(pos);
        BlockPos firePos = pos.func_177967_a(facing, igniter.getRangeUpgrades() + 1);
        if (flag) {
            if (world.func_175623_d(firePos)) {
                world.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
            }
        } else if (!flag && world.func_180495_p(firePos).func_177230_c() == Blocks.field_150480_ab) {
            world.func_175656_a(firePos, Blocks.field_150350_a.func_176223_P());
            world.func_184134_a((double)firePos.func_177958_n() + 0.5, (double)firePos.func_177956_o() + 0.5, (double)((float)firePos.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, true);
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityIgniter();
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityIgniter) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityIgniter)tileentity).inventory);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

