/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import trapcraft.tileentity.TileEntityTC;

public class PacketMagneticChestTile {
    public BlockPos pos;
    public String owner;
    public String customName;
    public String state;

    public PacketMagneticChestTile(BlockPos pos, String owner, String customName, String state) {
        this.pos = pos;
        this.owner = owner;
        this.customName = customName;
        this.state = state;
    }

    public static void encode(PacketMagneticChestTile msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.func_180714_a(msg.owner);
        buf.func_180714_a(msg.customName);
        buf.func_180714_a(msg.state);
    }

    public static PacketMagneticChestTile decode(PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        String owner = buf.func_150789_c(Short.MAX_VALUE);
        String customName = buf.func_150789_c(Short.MAX_VALUE);
        String state = buf.func_150789_c(Short.MAX_VALUE);
        return new PacketMagneticChestTile(pos, owner, customName, state);
    }

    public static class Handler {
        public static void handle(PacketMagneticChestTile msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
                TileEntity target = player.field_70170_p.func_175625_s(msg.pos);
                if (!(target instanceof TileEntityTC)) {
                    return;
                }
                TileEntityTC magneticChest = (TileEntityTC)target;
                magneticChest.setState(msg.state);
                magneticChest.setOwner(msg.owner);
                magneticChest.setInvName(msg.customName);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

