/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import trapcraft.ModBlocks;
import trapcraft.block.BlockMagneticChest;

public class TileEntityMagneticChest
extends TileEntityLockable
implements ITickable,
IInventory {
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private final int INVENTORY_SIZE = 27;
    private ITextComponent customName;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);

    public TileEntityMagneticChest() {
        super(ModBlocks.TILE_MAGNETIC_CHEST);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_73660_a() {
        this.pullItemsIn();
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, ModBlocks.MAGNETIC_CHEST, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        float f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d0 = (double)i + 0.5;
            double d1 = (double)k + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d0, (double)j + 0.5, d1, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f1;
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f1 = 0.5f) && f2 >= f1) {
                double d3 = (double)i + 0.5;
                double d2 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d2, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        return compound;
    }

    public void pullItemsIn() {
        List entity = this.field_145850_b.func_175644_a(EntityItem.class, item -> item.func_174818_b(this.field_174879_c) < 36.0);
        if (!entity.isEmpty()) {
            for (int i = 0; i < entity.size(); ++i) {
                EntityItem entityItem = (EntityItem)entity.get(i);
                double centreX = (double)this.field_174879_c.func_177958_n() + 0.5;
                double centreY = (double)this.field_174879_c.func_177956_o() + 0.5;
                double centreZ = (double)this.field_174879_c.func_177952_p() + 0.5;
                double diffX = -entityItem.field_70165_t + centreX;
                double diffY = -entityItem.field_70163_u + centreY;
                double diffZ = -entityItem.field_70161_v + centreZ;
                double speedMultiper = 0.05;
                double d11 = entityItem.field_70165_t - centreX;
                double d12 = entityItem.field_70161_v - centreZ;
                double horizDiffSq = MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ));
                double angle = Math.asin(diffX / horizDiffSq);
                double d15 = Math.abs((double)MathHelper.func_76126_a((float)((float)angle)) * speedMultiper);
                double d16 = Math.abs((double)MathHelper.func_76134_b((float)((float)angle)) * speedMultiper);
                d15 = diffX <= 0.0 ? -d15 : d15;
                double d = d16 = diffZ <= 0.0 ? -d16 : d16;
                if ((double)MathHelper.func_76135_e((float)((float)(entityItem.field_70159_w + entityItem.field_70181_x + entityItem.field_70179_y))) >= 0.1) continue;
                entityItem.field_70159_w = d15;
                if (diffY >= 0.6) {
                    entityItem.field_70181_x = speedMultiper * 2.0;
                }
                entityItem.field_70179_y = d16;
            }
        }
    }

    public boolean insertStackFromEntity(EntityItem entityItem) {
        boolean succesful = false;
        if (entityItem == null || !entityItem.func_70089_S()) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = this.insertStack(itemstack);
        if (!itemstack1.func_190926_b()) {
            entityItem.func_92058_a(itemstack1);
        } else {
            succesful = true;
            entityItem.func_70106_y();
        }
        return succesful;
    }

    public ItemStack insertStack(ItemStack stack) {
        int j = this.func_70302_i_();
        for (int k = 0; k < j && stack.func_190916_E() > 0; ++k) {
            stack = this.tryInsertStackToSlot(stack, k);
        }
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public ItemStack tryInsertStackToSlot(ItemStack stack, int slot) {
        ItemStack slotStack = this.func_70301_a(slot);
        if (this.func_94041_b(slot, stack)) {
            int max;
            boolean changed = false;
            if (slotStack.func_190926_b()) {
                int max2 = Math.min(stack.func_77976_d(), this.func_70297_j_());
                if (max2 >= stack.func_190916_E()) {
                    this.func_70299_a(slot, stack);
                    stack = ItemStack.field_190927_a;
                } else {
                    this.func_70299_a(slot, stack.func_77979_a(max2));
                }
                changed = true;
            } else if (this.areItemStacksEqualItem(slotStack, stack) && (max = Math.min(stack.func_77976_d(), this.func_70297_j_())) > slotStack.func_190916_E()) {
                int l = Math.min(stack.func_190916_E(), max - slotStack.func_190916_E());
                stack.func_190918_g(l);
                slotStack.func_190917_f(l);
                boolean bl = changed = l > 0;
            }
            if (changed) {
                this.func_70296_d();
            }
        }
        return stack;
    }

    private boolean areItemStacksEqualItem(ItemStack p_145894_0_, ItemStack p_145894_1_) {
        return p_145894_0_.func_77973_b() != p_145894_1_.func_77973_b() ? false : (p_145894_0_.func_190916_E() > p_145894_0_.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)p_145894_0_, (ItemStack)p_145894_1_));
    }

    public boolean func_94041_b(int side, ItemStack itemStack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void setInvName(ITextComponent customName) {
        this.customName = customName;
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container.trapcraft.magnetic_chest", new Object[0]);
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockMagneticChest) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    public String func_174875_k() {
        return "trapcraft:magnetic_chest";
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

