/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import trapcraft.block.BlockBearTrap;
import trapcraft.block.BlockFan;
import trapcraft.block.BlockGrassCovering;
import trapcraft.block.BlockIgniter;
import trapcraft.block.BlockMagneticChest;
import trapcraft.block.BlockSpikes;
import trapcraft.client.renders.TileEntityItemStackMagneticChestRenderer;

@ObjectHolder(value="trapcraft")
public class ModBlocks {
    public static final Block FAN = null;
    public static final Block MAGNETIC_CHEST = null;
    public static final Block GRASS_COVERING = null;
    public static final Block BEAR_TRAP = null;
    public static final Block SPIKES = null;
    public static final Block IGNITER = null;

    @Mod.EventBusSubscriber(modid="trapcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            blockRegistry.register(new BlockFan().setRegistryName("trapcraft:fan"));
            blockRegistry.register(new BlockMagneticChest().setRegistryName("trapcraft:magnetic_chest"));
            blockRegistry.register(new BlockGrassCovering().setRegistryName("trapcraft:grass_covering"));
            blockRegistry.register(new BlockBearTrap().setRegistryName("trapcraft:bear_trap"));
            blockRegistry.register(new BlockSpikes().setRegistryName("trapcraft:spikes"));
            blockRegistry.register(new BlockIgniter().setRegistryName("trapcraft:igniter"));
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            itemRegistry.register(new BlockItem(MAGNETIC_CHEST, new Item.Properties().func_200916_a(ItemGroup.field_78028_d).setTEISR(() -> TileEntityItemStackMagneticChestRenderer::new)).setRegistryName(MAGNETIC_CHEST.getRegistryName()));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeBlockItem(GRASS_COVERING));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeBlockItem(FAN));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeBlockItem(BEAR_TRAP));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeBlockItem(SPIKES));
            itemRegistry.register((IForgeRegistryEntry)Registration.makeBlockItem(IGNITER));
        }

        private static BlockItem makeBlockItem(Block block) {
            return Registration.makeBlockItem(block, ItemGroup.field_78028_d);
        }

        private static BlockItem makeBlockItem(Block block, ItemGroup group) {
            return (BlockItem)new BlockItem(block, new Item.Properties().func_200916_a(group)).setRegistryName(block.getRegistryName());
        }
    }
}

