/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.client.renders;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.client.renderer.tileentity.model.LargeChestModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import trapcraft.api.Properties;
import trapcraft.tileentity.TileEntityMagneticChest;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityMagneticChestRenderer
extends TileEntityRenderer<TileEntityMagneticChest> {
    private final ChestModel simpleChest = new ChestModel();
    private final ChestModel largeChest = new LargeChestModel();

    public void render(TileEntityMagneticChest tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        ChestType chesttype;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState blockstate = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chestType = chesttype = blockstate.func_196959_b((IProperty)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((IProperty)ChestBlock.field_196314_b) : ChestType.SINGLE;
        if (chesttype != ChestType.LEFT) {
            boolean flag = chesttype != ChestType.SINGLE;
            ChestModel chestmodel = this.getModelWithTexture(tileEntityIn, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)blockstate.func_177229_b((IProperty)ChestBlock.field_176459_a)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.func_199346_a(tileEntityIn, partialTicks, chestmodel);
            chestmodel.func_78231_a();
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    public ChestModel getModelWithTexture(TileEntityMagneticChest magneticChest, int destoryStage, boolean doubleChest) {
        ResourceLocation resourcelocation = destoryStage >= 0 ? field_178460_a[destoryStage] : (doubleChest ? Properties.RES_BLOCK_MAGNETIC_CHEST : Properties.RES_BLOCK_MAGNETIC_CHEST);
        this.func_147499_a(resourcelocation);
        return doubleChest ? this.largeChest : this.simpleChest;
    }

    private void func_199346_a(TileEntityMagneticChest p_199346_1_, float p_199346_2_, ChestModel p_199346_3_) {
        float f = p_199346_1_.func_195480_a(p_199346_2_);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        p_199346_3_.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }
}

