/*
 * Decompiled with CFR 0.152.
 */
package trapcraft;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftContainerTypes;
import trapcraft.TrapcraftEntityTypes;
import trapcraft.TrapcraftItems;
import trapcraft.TrapcraftTileEntityTypes;
import trapcraft.api.Constants;
import trapcraft.client.gui.IgniterScreen;
import trapcraft.client.renders.DummyRenderer;
import trapcraft.client.renders.ItemStackTileEntityMagneticChestRenderer;
import trapcraft.client.renders.TileEntityMagneticChestRenderer;
import trapcraft.config.ConfigHandler;
import trapcraft.data.TrapcraftBlockstateProvider;
import trapcraft.data.TrapcraftItemModelProvider;
import trapcraft.data.TrapcraftLootTableProvider;
import trapcraft.data.TrapcraftRecipeProvider;
import trapcraft.handler.ActionHandler;
import trapcraft.network.PacketHandler;

@Mod(value="trapcraft")
public class TrapcraftMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Trapcraft");
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("trapcraft", "channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static TrapcraftMod INSTANCE;

    public TrapcraftMod() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TrapcraftBlocks.BLOCKS.register(modEventBus);
        TrapcraftTileEntityTypes.TILE_ENTITIES.register(modEventBus);
        TrapcraftItems.ITEMS.register(modEventBus);
        TrapcraftEntityTypes.ENTITIES.register(modEventBus);
        TrapcraftContainerTypes.CONTAINERS.register(modEventBus);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::interModProcess);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerBlockColors);
            modEventBus.addListener(this::registerItemColors);
            modEventBus.addListener(this::addTexturesToAtlas);
        });
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.register((Object)new ActionHandler());
        ConfigHandler.init(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        TrapcraftEntityTypes.addEntityAttributes();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)TrapcraftEntityTypes.DUMMY.get()), DummyRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)TrapcraftContainerTypes.IGNITER.get()), IgniterScreen::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TrapcraftTileEntityTypes.MAGNETIC_CHEST.get()), TileEntityMagneticChestRenderer::new);
        RenderTypeLookup.setRenderLayer((Block)((Block)TrapcraftBlocks.SPIKES.get()), (RenderType)RenderType.func_228643_e_());
        ItemStackTileEntityMagneticChestRenderer.setDummyTE();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, blockAccess, pos, tintIndex) -> blockAccess != null && pos != null ? BiomeColors.func_228358_a_((IBlockDisplayReader)blockAccess, (BlockPos)pos) : -1, new Block[]{(Block)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{(IItemProvider)TrapcraftBlocks.GRASS_COVERING.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addTexturesToAtlas(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            event.addSprite(Constants.RES_BLOCK_MAGNETIC_CHEST);
        }
    }

    private void interModProcess(InterModProcessEvent event) {
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            TrapcraftBlockstateProvider blockstates = new TrapcraftBlockstateProvider(gen, event.getExistingFileHelper());
            gen.func_200390_a((IDataProvider)blockstates);
            gen.func_200390_a((IDataProvider)new TrapcraftItemModelProvider(gen, blockstates.getExistingHelper()));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new TrapcraftRecipeProvider(gen));
            gen.func_200390_a((IDataProvider)new TrapcraftLootTableProvider(gen));
        }
    }
}

