/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import trapcraft.block.tileentity.IgniterTileEntity;

public class IgniterBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public IgniterBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.5f, 2.0f).func_200947_a(SoundType.field_185851_d));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.WEST));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        IgniterTileEntity tileentityigniter = (IgniterTileEntity)worldIn.func_175625_s(pos);
        if (tileentityigniter != null && player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            ServerPlayerEntity entityPlayerMP = (ServerPlayerEntity)player;
            NetworkHooks.openGui((ServerPlayerEntity)entityPlayerMP, (INamedContainerProvider)tileentityigniter, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        this.updateIgniterState((World)world, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.updateIgniterState(worldIn, pos);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void updateIgniterState(World world, BlockPos pos) {
        IgniterTileEntity igniter;
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        int distance = 1;
        int oldDistance = 1;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IgniterTileEntity) {
            igniter = (IgniterTileEntity)world.func_175625_s(pos);
            distance = igniter.getRangeUpgrades() + 1;
            oldDistance = igniter.lastUpgrades + 1;
        }
        this.updateIgniterState(world, pos, world.func_175640_z(pos), facing, distance, oldDistance);
        if (tileEntity instanceof IgniterTileEntity) {
            igniter = (IgniterTileEntity)world.func_175625_s(pos);
            igniter.lastUpgrades = distance - 1;
        }
    }

    private void updateIgniterState(World world, BlockPos pos, boolean powered, Direction direction, int newDistance, int previousDistance) {
        if (newDistance != previousDistance) {
            BlockPos oldPos = pos.func_177967_a(direction, previousDistance);
            this.removePossibleFire(world, oldPos);
        }
        BlockPos firePos = pos.func_177967_a(direction, newDistance);
        if (powered) {
            if (world.func_175623_d(firePos)) {
                world.func_175656_a(firePos, Blocks.field_150480_ab.func_176223_P());
            }
        } else if (!powered) {
            this.removePossibleFire(world, firePos);
        }
    }

    public void removePossibleFire(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150480_ab) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, true);
        }
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new IgniterTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileentity = worldIn.func_175625_s(pos)) instanceof IgniterTileEntity) {
            int upgrades = ((IgniterTileEntity)tileentity).getRangeUpgrades() + 1;
            this.updateIgniterState(worldIn, pos, false, (Direction)state.func_177229_b((Property)FACING), upgrades, upgrades);
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IgniterTileEntity)tileentity).inventory);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }
}

