/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrassCovering
extends Block {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);

    public BlockGrassCovering() {
        super(Material.field_151577_b);
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!this.canBlockStay((World)world, pos)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos posOff = pos.func_177972_a(facing);
            IBlockState blockstate = world.func_180495_p(posOff);
            if (!blockstate.func_177230_c().isSideSolid(blockstate, (IBlockAccess)world, posOff, facing.func_176734_d()) && blockstate.func_177230_c() != this) continue;
            return true;
        }
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase && !world.field_72995_K) {
            world.func_175698_g(pos);
            for (int l = 0; l < 2; ++l) {
                float f = 0.7f;
                float f1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
                float f2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
                float f3 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + (double)f1, (double)pos.func_177956_o() + (double)f2, (double)pos.func_177952_p() + (double)f3, new ItemStack(Items.field_151055_y));
                entityitem.func_174867_a(10);
                world.func_72838_d((Entity)entityitem);
            }
        }
    }
}

