/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.micro;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.util.AudioUtil;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class MicroData
implements NoExceptionCloseable {
    public static final AudioFormat FORMAT = new AudioFormat(48000.0f, 16, 2, true, false);
    public static final DataLine.Info MIC_INFO = new DataLine.Info(TargetDataLine.class, FORMAT);
    private Mixer mixer;
    private TargetDataLine targetLine;
    private int volume;
    private int multiplier;

    public MicroData(String microName, int volume) {
        this.setMixer(microName);
        this.setVolume(volume);
    }

    private boolean createLine() {
        if (this.mixer != null) {
            try {
                TargetDataLine line = (TargetDataLine)this.mixer.getLine(MIC_INFO);
                line.open(FORMAT, 15360);
                line.start();
                this.targetLine = line;
                return true;
            }
            catch (LineUnavailableException lineUnavailableException) {
                // empty catch block
            }
        }
        return false;
    }

    private void closeLine() {
        if (this.targetLine != null) {
            this.targetLine.flush();
            this.targetLine.stop();
            this.targetLine.close();
        }
    }

    public String getMixer() {
        if (this.mixer != null) {
            return this.mixer.getMixerInfo().getName();
        }
        return null;
    }

    public void setMixer(String name) {
        if (this.mixer != null && this.mixer.getMixerInfo().getName().equals(name)) {
            return;
        }
        Mixer oldMixer = this.mixer;
        this.mixer = AudioUtil.findMixer(name, MIC_INFO);
        this.closeLine();
        this.targetLine = null;
        if (oldMixer != null && !AudioUtil.hasLinesOpen(oldMixer)) {
            oldMixer.close();
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.multiplier = AudioUtil.calculateVolumeMultiplier(volume);
    }

    public boolean isAvailable() {
        if (this.mixer != null) {
            if (this.targetLine != null) {
                return this.targetLine.isOpen();
            }
            return this.createLine();
        }
        return false;
    }

    public void flush() {
        if (this.isAvailable()) {
            this.targetLine.flush();
        }
    }

    public byte[] read(byte[] array) {
        if (this.isAvailable()) {
            this.targetLine.read(array, 0, array.length);
            AudioUtil.changeVolume(array, this.volume, this.multiplier);
        }
        return array;
    }

    @Override
    public void close() {
        this.closeLine();
        if (this.mixer != null && !AudioUtil.hasLinesOpen(this.mixer)) {
            this.mixer.close();
        }
    }
}

