/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final ForgeConfigSpec CONFIG;
    private static final ClientConfig INSTANCE;
    public final ForgeConfigSpec.ConfigValue<String> microphoneValue;
    public final ForgeConfigSpec.IntValue microphoneVolumeValue;
    public final ForgeConfigSpec.ConfigValue<String> speakerValue;
    public final ForgeConfigSpec.IntValue speakerVolumeValue;
    public final ForgeConfigSpec.IntValue bitrateValue;
    public final ForgeConfigSpec.IntValue musicBitrateValue;

    public static ClientConfig getInstance() {
        return INSTANCE;
    }

    private ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Voice settings").push("client");
        builder.push("microphone");
        this.microphoneValue = builder.comment("Which microphone should be used. If empty or microphone not found the default one will be used. If no microphone is found the mod cannot record voice data.").define("microphone", (Object)"");
        this.microphoneVolumeValue = builder.comment("The volume of the microphone in a linear range").defineInRange("volume", 100, 0, 150);
        builder.pop();
        builder.push("speaker");
        this.speakerValue = builder.comment("Which speaker should be used. If empty or speaker not found the default one will be used. If no speaker is found the mod cannot play voice data.").define("speaker", (Object)"");
        this.speakerVolumeValue = builder.comment("The volume of the speaker in a linear range").defineInRange("volume", 100, 0, 150);
        builder.pop();
        this.bitrateValue = builder.comment("The bitrate your voice packets are send to the server. If packet loss occurs try to lower the bitrate.").defineInRange("bitrate", 64000, 8000, 128000);
        this.musicBitrateValue = builder.comment("The bitrate your music packets are send to the server if your stream your music player. If packet loss occurs try to lower the bitrate.").defineInRange("bitrate", 96000, 8000, 128000);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (ClientConfig)pair.getLeft();
    }
}

