/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.message;

import info.u_team.voice_chat.client.PlayerIDManager;
import info.u_team.voice_chat.client.VoiceClientManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerIDJoinMessage {
    private final UUID[] uuids;
    private final short[] ids;

    public PlayerIDJoinMessage(UUID[] uuids, short[] ids) {
        this.uuids = uuids;
        this.ids = ids;
    }

    public static void encode(PlayerIDJoinMessage message, PacketBuffer buffer) {
        buffer.writeShort(message.uuids.length);
        for (int index = 0; index < message.uuids.length; ++index) {
            buffer.func_179252_a(message.uuids[index]);
            buffer.writeShort((int)message.ids[index]);
        }
    }

    public static PlayerIDJoinMessage decode(PacketBuffer buffer) {
        int size = buffer.readShort();
        UUID[] uuids = new UUID[size];
        short[] ids = new short[size];
        for (int index = 0; index < size; ++index) {
            uuids[index] = buffer.func_179253_g();
            ids[index] = buffer.readShort();
        }
        return new PlayerIDJoinMessage(uuids, ids);
    }

    public static class Handler {
        public static void handle(PlayerIDJoinMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            VoiceClientManager.EXECUTOR.execute(() -> PlayerIDManager.addAllPlayers(message.uuids, message.ids));
            context.setPacketHandled(true);
        }
    }
}

