/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.message;

import info.u_team.voice_chat.client.PlayerIDManager;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerIDMessage {
    private final boolean delete;
    private final UUID uuid;
    private final short id;

    public PlayerIDMessage(boolean delete, UUID uuid, short id) {
        this.delete = delete;
        this.uuid = uuid;
        this.id = id;
    }

    public static void encode(PlayerIDMessage message, PacketBuffer buffer) {
        buffer.writeBoolean(message.delete);
        buffer.func_179252_a(message.uuid);
        if (!message.delete) {
            buffer.writeShort((int)message.id);
        }
    }

    public static PlayerIDMessage decode(PacketBuffer buffer) {
        boolean delete = buffer.readBoolean();
        return new PlayerIDMessage(delete, buffer.func_179253_g(), delete ? (short)0 : buffer.readShort());
    }

    public static class Handler {
        public static void handle(PlayerIDMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            if (message.delete) {
                PlayerIDManager.removePlayer(message.uuid);
            } else {
                PlayerIDManager.addPlayer(message.uuid, message.id);
            }
            context.setPacketHandled(true);
        }
    }
}

