/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.server;

import info.u_team.voice_chat.config.CommonConfig;
import info.u_team.voice_chat.init.VoiceChatNetworks;
import info.u_team.voice_chat.message.PlayerIDJoinMessage;
import info.u_team.voice_chat.message.PlayerIDMessage;
import info.u_team.voice_chat.message.ServerPortHandshakeMessage;
import info.u_team.voice_chat.server.PlayerSecretManager;
import info.u_team.voice_chat.server.VerifiedPlayerManager;
import info.u_team.voice_chat.server.VoiceServerManager;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="voicechat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEventHandler {
    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        PlayerSecretManager.addPlayer(player);
        VoiceChatNetworks.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ServerPortHandshakeMessage((Integer)CommonConfig.getInstance().portValue.get(), PlayerSecretManager.getSecretByPlayer(player)));
        Map<UUID, VerifiedPlayerManager.PlayerData> map = VerifiedPlayerManager.getMap();
        UUID[] uuids = new UUID[map.size()];
        short[] ids = new short[map.size()];
        int counter = 0;
        for (Map.Entry<UUID, VerifiedPlayerManager.PlayerData> entry : map.entrySet()) {
            uuids[counter] = entry.getKey();
            ids[counter] = entry.getValue().getId();
            ++counter;
        }
        VoiceChatNetworks.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayerIDJoinMessage(uuids, ids));
    }

    @SubscribeEvent
    public static void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.getPlayer() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        VerifiedPlayerManager.removePlayer(player);
        PlayerSecretManager.removePlayer(player);
        VoiceChatNetworks.NETWORK.send(PacketDistributor.ALL.noArg(), (Object)new PlayerIDMessage(true, player.func_110124_au(), 0));
    }

    @SubscribeEvent
    public static void start(FMLServerStartingEvent event) {
        VoiceServerManager.start();
    }

    @SubscribeEvent
    public static void stop(FMLServerStoppingEvent event) {
        VoiceServerManager.stop();
    }
}

