/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.server;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.ServerPlayerEntity;

public class VerifiedPlayerManager {
    private static final Map<UUID, PlayerData> MAP = new HashMap<UUID, PlayerData>();

    public static synchronized void addPlayer(ServerPlayerEntity player, PlayerData playerData) {
        if (!MAP.containsKey(player.func_110124_au())) {
            MAP.put(player.func_110124_au(), playerData);
        }
    }

    public static synchronized void removePlayer(ServerPlayerEntity player) {
        MAP.remove(player.func_110124_au());
    }

    public static PlayerData getPlayerData(ServerPlayerEntity player) {
        return MAP.get(player.func_110124_au());
    }

    public static boolean hasPlayerData(ServerPlayerEntity player) {
        return MAP.containsKey(player.func_110124_au());
    }

    public static Map<UUID, PlayerData> getMap() {
        return Collections.unmodifiableMap(MAP);
    }

    public static class PlayerData {
        private static final AtomicInteger COUNTER = new AtomicInteger();
        private final InetSocketAddress address;
        private final short id;

        public PlayerData(InetSocketAddress address) {
            this.address = address;
            this.id = (short)COUNTER.getAndIncrement();
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public short getId() {
            return this.id;
        }
    }
}

