/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.server;

import info.u_team.voice_chat.packet.PacketRegistry;
import info.u_team.voice_chat.server.PlayerSecretManager;
import info.u_team.voice_chat.server.VerifiedPlayerManager;
import info.u_team.voice_chat.util.NetworkUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.entity.player.ServerPlayerEntity;

public class VoiceServer {
    private final DatagramSocket socket = new DatagramSocket(NetworkUtil.findServerBindAddress());
    private final Future<?> task;

    public VoiceServer(ExecutorService service) throws SocketException {
        this.task = service.submit(() -> {
            while (!Thread.currentThread().isInterrupted() && !this.socket.isClosed()) {
                try {
                    DatagramPacket packet = new DatagramPacket(new byte[1008], 1008);
                    this.socket.receive(packet);
                    if (packet.getLength() < 9) {
                        return;
                    }
                    ByteBuffer buffer = ByteBuffer.wrap(packet.getData(), 0, packet.getLength());
                    byte[] secret = new byte[8];
                    buffer.get(secret);
                    ServerPlayerEntity player = PlayerSecretManager.getPlayerBySecret(secret);
                    if (player == null) {
                        return;
                    }
                    byte[] data = new byte[buffer.remaining()];
                    buffer.get(data);
                    Object message = PacketRegistry.decode(data, data.length);
                    if (message == null) continue;
                    PacketRegistry.handle(message, PacketRegistry.Context.Sender.PLAYER, (InetSocketAddress)packet.getSocketAddress(), player);
                }
                catch (IOException ex) {
                    if (this.socket.isClosed()) continue;
                    ex.printStackTrace();
                }
            }
        });
    }

    public <MSG> void sendPlayer(ServerPlayerEntity player, MSG message) {
        this.sendIntern(Arrays.asList(VerifiedPlayerManager.getPlayerData(player)), message);
    }

    public <MSG> void sendAll(MSG message) {
        this.sendIntern(VerifiedPlayerManager.getMap().values(), message);
    }

    public <MSG> void sendAllExcept(MSG message, ServerPlayerEntity except) {
        this.sendIntern(VerifiedPlayerManager.getMap().entrySet().stream().filter(entry -> !((UUID)entry.getKey()).equals(except.func_110124_au())).map(Map.Entry::getValue).collect(Collectors.toList()), message);
    }

    private <MSG> void sendIntern(Collection<VerifiedPlayerManager.PlayerData> players, MSG message) {
        byte[] data = PacketRegistry.encode(message);
        if (data == null) {
            return;
        }
        players.stream().forEach(playerData -> {
            block2: {
                try {
                    this.socket.send(new DatagramPacket(data, data.length, playerData.getAddress()));
                }
                catch (IOException ex) {
                    if (this.socket.isClosed()) break block2;
                    ex.printStackTrace();
                }
            }
        });
    }

    public void close() {
        this.socket.close();
        this.task.cancel(true);
    }
}

