/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.speaker.SpeakerData;
import info.u_team.voice_chat.audio_client.speaker.SpeakerPlayer;
import info.u_team.voice_chat.config.ClientConfig;

public class SpeakerHandler
implements NoExceptionCloseable {
    private final ClientConfig config = ClientConfig.getInstance();
    private final SpeakerData data;
    private final SpeakerPlayer player;

    public SpeakerHandler() {
        this.data = new SpeakerData((String)this.config.speakerValue.get(), (Integer)this.config.speakerVolumeValue.get());
        this.player = new SpeakerPlayer(this.data);
    }

    public void receiveVoicePacket(int id, byte[] opusPacket) {
        this.player.accept(id, opusPacket);
    }

    public String getSpeaker() {
        return this.data.getMixer();
    }

    public void setSpeaker(String mixer) {
        this.data.setMixer(mixer);
        this.config.speakerValue.set((Object)mixer);
        ClientConfig.CONFIG.save();
    }

    public int getVolume() {
        return this.data.getVolume();
    }

    public void setVolume(int volume) {
        this.data.setVolume(volume);
        this.config.speakerVolumeValue.set((Object)volume);
        ClientConfig.CONFIG.save();
    }

    @Override
    public void close() {
        this.player.close();
        this.data.close();
    }
}

