/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.opus;

import info.u_team.voice_chat.audio_client.api.opus.IOpusEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.opus.Opus;

public class PcmOpusEncoder
implements IOpusEncoder {
    private final int frameSize;
    private final long instance;
    private final ByteBuffer inputBuffer;
    private final ShortBuffer inputShortBuffer;
    private final ByteBuffer outputBuffer;

    public PcmOpusEncoder(int sampleRate, int channel, int milliseconds, int bitrate, int signal, int bufferSize) {
        this.frameSize = sampleRate / (1000 / milliseconds);
        this.instance = Opus.opus_encoder_create((int)sampleRate, (int)channel, (int)2049, null);
        Opus.opus_encoder_ctl((long)this.instance, (Opus.CTLRequest)Opus.OPUS_SET_BITRATE((int)bitrate));
        Opus.opus_encoder_ctl((long)this.instance, (Opus.CTLRequest)Opus.OPUS_SET_SIGNAL((int)signal));
        Opus.opus_encoder_ctl((long)this.instance, (Opus.CTLRequest)Opus.OPUS_SET_COMPLEXITY((int)10));
        this.inputBuffer = MemoryUtil.memCalloc((int)(this.frameSize * channel * 2));
        this.inputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.inputShortBuffer = this.inputBuffer.asShortBuffer();
        this.outputBuffer = MemoryUtil.memCalloc((int)bufferSize);
        this.inputBuffer.mark();
        this.inputShortBuffer.mark();
        this.outputBuffer.mark();
    }

    @Override
    public byte[] encode(byte[] pcm) {
        this.inputBuffer.reset();
        this.inputShortBuffer.reset();
        this.outputBuffer.reset();
        this.inputBuffer.limit(pcm.length);
        this.inputBuffer.put(pcm);
        this.inputBuffer.reset();
        int encodedLength = Opus.opus_encode((long)this.instance, (ShortBuffer)this.inputShortBuffer, (int)this.frameSize, (ByteBuffer)this.outputBuffer);
        byte[] buffer = new byte[encodedLength];
        this.outputBuffer.get(buffer);
        return buffer;
    }

    @Override
    public byte[] silence() {
        return new byte[]{-8, -1, -2};
    }

    @Override
    public void close() {
        Opus.opus_encoder_destroy((long)this.instance);
        MemoryUtil.memFree((Buffer)this.inputBuffer);
        MemoryUtil.memFree((Buffer)this.outputBuffer);
    }
}

