/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.audio_client.speaker;

import info.u_team.voice_chat.audio_client.api.NoExceptionCloseable;
import info.u_team.voice_chat.audio_client.opus.PcmOpusDecoder;
import info.u_team.voice_chat.audio_client.speaker.SpeakerBuffer;
import info.u_team.voice_chat.audio_client.speaker.SpeakerData;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class SpeakerBufferPusher
implements NoExceptionCloseable {
    private final SpeakerBuffer buffer = new SpeakerBuffer(10);
    private final PcmOpusDecoder decoder = new PcmOpusDecoder(48000, 2, 20, 1000);
    private final Future<?> future;

    public SpeakerBufferPusher(ExecutorService executor, int id, SpeakerData speakerData) {
        this.future = executor.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                if (!speakerData.isAvailable(id) || speakerData.freeBuffer(id) <= 0) continue;
                speakerData.write(id, this.buffer.getNextPacket());
            }
        });
    }

    public void decodeAndPushPacket(byte[] opusPacket) {
        this.pushPacket(this.decoder.decoder(opusPacket));
    }

    private void pushPacket(byte[] packet) {
        this.buffer.pushPacket(packet);
    }

    @Override
    public void close() {
        this.future.cancel(true);
        this.decoder.close();
    }
}

