/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.voice_chat.musicplayer_integration;

import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.voice_chat.api.IIntegration;
import info.u_team.voice_chat.audio_client.api.opus.IOpusEncoder;
import info.u_team.voice_chat.audio_client.opus.PcmOpusEncoder;
import info.u_team.voice_chat.audio_client.util.EndianUtil;
import info.u_team.voice_chat.audio_client.util.ThreadUtil;
import info.u_team.voice_chat.client.TalkingManager;
import info.u_team.voice_chat.client.VoiceClientManager;
import info.u_team.voice_chat.config.ClientConfig;
import info.u_team.voice_chat.musicplayer_integration.message.MusicToServerPacket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;

public class MusicPlayerIntegration
implements IIntegration {
    private static MusicPlayerIntegration INSTANCE;
    private ExecutorService executor;
    private IOpusEncoder encoder;
    private volatile boolean shouldStream;

    public static MusicPlayerIntegration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MusicPlayerIntegration();
        }
        return INSTANCE;
    }

    @Override
    public void start() {
        this.executor = Executors.newSingleThreadExecutor(ThreadUtil.createDaemonFactory("music player sender"));
        this.encoder = new PcmOpusEncoder(48000, 2, 20, (Integer)ClientConfig.getInstance().musicBitrateValue.get(), 3002, 1000);
        this.shouldStream = false;
        MusicPlayerManager.getPlayer().setOutputConsumer((buffer, length) -> this.executor.execute(() -> {
            if (!this.shouldStream) {
                return;
            }
            if (MusicPlayerManager.getPlayer().getVolume() == 0) {
                return;
            }
            if (VoiceClientManager.isRunning()) {
                EndianUtil.endianConverter(buffer, 4);
                byte[] encoded = this.encoder.encode(buffer);
                VoiceClientManager.getClient().send(new MusicToServerPacket(encoded));
                TalkingManager.addOrUpdate(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            }
        }));
    }

    @Override
    public void stop() {
        MusicPlayerManager.getPlayer().setOutputConsumer(null);
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        if (this.encoder != null) {
            this.encoder.close();
            this.encoder = null;
        }
        this.shouldStream = false;
    }

    public void setShouldStream(boolean shouldStream) {
        this.shouldStream = shouldStream;
    }

    public boolean isShouldStream() {
        return this.shouldStream;
    }
}

