/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.blocks;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.ommina.wallpapercraft.blocks.DecorativeBlock;
import net.ommina.wallpapercraft.blocks.DecorativeBlockGlass;
import net.ommina.wallpapercraft.blocks.DecorativeBlockPatterned;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static final String[] COLOURS = new String[]{"blue", "brown", "cyan", "gray", "green", "purple", "red", "yellow"};
    public static final String[] PATTERNS = new String[]{"auralamp", "solid", "brick", "checkeredwool", "clay", "colouredbrick", "damask", "diagonallydotted", "dotted", "fancytiles", "floral", "frostedglass", "jewel", "rippled", "stamp", "stonebrick", "stonelamp", "striped", "texturedglass", "tintedglass", "woodplank", "wool"};
    public static final Map<String, DecorativeBlock> BLOCKS = new HashMap<String, DecorativeBlock>();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerColouredBlocks(event, "auralamp", Material.field_151576_e, SoundType.field_222475_v, true);
        ModBlocks.registerColouredBlocks(event, "stonelamp", Material.field_151576_e, SoundType.field_222475_v, true);
        ModBlocks.registerColouredBlocks(event, "frostedglass", Material.field_151592_s, SoundType.field_185853_f, false);
        ModBlocks.registerColouredBlocks(event, "texturedglass", Material.field_151592_s, SoundType.field_185853_f, false);
        ModBlocks.registerColouredBlocks(event, "tintedglass", Material.field_151592_s, SoundType.field_185853_f, false);
        ModBlocks.registerColouredBlocks(event, "checkeredwool", Material.field_151580_n, SoundType.field_185854_g, false);
        ModBlocks.registerColouredBlocks(event, "wool", Material.field_151580_n, SoundType.field_185854_g, false);
        ModBlocks.registerColouredBlocks(event, "clay", Material.field_151571_B, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "woodplank", Material.field_151575_d, SoundType.field_185848_a, false);
        ModBlocks.registerColouredBlocks(event, "brick", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "colouredbrick", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "damask", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "diagonallydotted", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "dotted", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "fancytiles", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "floral", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "rippled", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "solid", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "stonebrick", Material.field_151576_e, SoundType.field_185851_d, false);
        ModBlocks.registerColouredBlocks(event, "striped", Material.field_151576_e, SoundType.field_185851_d, false);
    }

    private static void registerColouredBlocks(RegistryEvent.Register<Block> event, String variant, Material material, SoundType soundType, boolean isLight) {
        for (String s : COLOURS) {
            int suffixCount = s.equals("cyan") ? 9 : 14;
            for (int suffix = 0; suffix <= suffixCount; ++suffix) {
                int light = isLight ? 15 : 0;
                DecorativeBlockPatterned block = material == Material.field_151592_s ? new DecorativeBlockGlass(variant, s, suffix, material, soundType, light) : new DecorativeBlockPatterned(variant, s, suffix, material, soundType, light);
                event.getRegistry().register((IForgeRegistryEntry)block);
                BLOCKS.put(block.getName(), block);
            }
        }
    }
}

