/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.events;

import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.ommina.wallpapercraft.items.ModItems;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootTableHandler {
    @SubscribeEvent
    public static void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTables.field_186420_b)) {
            LootTableHandler.addLootToTable(event.getTable(), 1, 64, false);
        } else if (event.getName().equals((Object)LootTables.field_215818_i)) {
            LootTableHandler.addLootToTable(event.getTable(), 4, 32, true);
        } else if (event.getName().equals((Object)LootTables.field_215829_t)) {
            LootTableHandler.addLootToTable(event.getTable(), 3, 32, true);
        } else if (event.getName().equals((Object)LootTables.field_215825_p) || event.getName().equals((Object)LootTables.field_215826_q) || event.getName().equals((Object)LootTables.field_215828_s) || event.getName().equals((Object)LootTables.field_215827_r)) {
            LootTableHandler.addLootToTable(event.getTable(), 1, 32, true);
        }
    }

    private static void addLootToTable(LootTable table, int rolls, int stackSize, boolean addAPattern) {
        table.addPool(LootTableHandler.getCommonPool(rolls, stackSize));
        if (addAPattern) {
            table.addPool(LootTableHandler.getPatternPool());
        }
    }

    private static LootPool getCommonPool(int rolls, int stackSize) {
        LootPool.Builder pool = LootPool.func_216096_a().name("wallpapercraftcommon").func_216046_a((IRandomRange)new ConstantRange(rolls));
        StandaloneLootEntry.Builder lootEntry = ItemLootEntry.func_216168_a((IItemProvider)ModItems.BASE_ITEM);
        LootFunction.Builder function = SetCount.func_215932_a((IRandomRange)new ConstantRange(stackSize));
        lootEntry.func_212841_b_((ILootFunction.IBuilder)function);
        pool.func_216045_a((LootEntry.Builder)lootEntry);
        return pool.func_216044_b();
    }

    private static LootPool getPatternPool() {
        LootPool.Builder pool = LootPool.func_216096_a().name("wallpapercraftpattern").func_216046_a((IRandomRange)new ConstantRange(1));
        LootFunction.Builder function = SetCount.func_215932_a((IRandomRange)new ConstantRange(1));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_CLAY).func_212841_b_((ILootFunction.IBuilder)function));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_WOOD_PLANK).func_212841_b_((ILootFunction.IBuilder)function));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_COLOURED_BRICK).func_212841_b_((ILootFunction.IBuilder)function));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_SOLID).func_212841_b_((ILootFunction.IBuilder)function));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_STONE_BRICK).func_212841_b_((ILootFunction.IBuilder)function));
        pool.func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.PRESS_STRIPED).func_212841_b_((ILootFunction.IBuilder)function));
        return pool.func_216044_b();
    }
}

