/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.ommina.wallpapercraft.Wallpapercraft;
import net.ommina.wallpapercraft.integration.PressCraftingCategory;
import net.ommina.wallpapercraft.recipes.PressCraftingRecipe;

@JeiPlugin
public class JustEnoughItems
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = Wallpapercraft.getId("plugin/main");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JustEnoughItems.getRecipesOfType(IRecipeType.field_222149_a), VanillaRecipeCategoryUid.CRAFTING);
        JustEnoughItems.addInfoPage(registration, (IItemProvider)PressCraftingCategory.BASE_ITEM.func_77973_b());
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory category = registration.getCraftingCategory();
        category.addCategoryExtension(PressCraftingRecipe.class, PressCraftingCategory::new);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        ArrayList<ItemStack> removals = new ArrayList<ItemStack>();
        removals.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(Wallpapercraft.getId("pressstamp"))));
        removals.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(Wallpapercraft.getId("pressjewel"))));
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, removals);
    }

    private static List<IRecipe> getRecipesOfType(IRecipeType<?> recipeType) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r instanceof PressCraftingRecipe).collect(Collectors.toList());
    }

    private static void addInfoPage(IRecipeRegistration reg, IItemProvider item) {
        String key = JustEnoughItems.getDescKey(Objects.requireNonNull(item.func_199767_j().getRegistryName()));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{key});
    }

    private static String getDescKey(ResourceLocation name) {
        return "jei." + name.func_110624_b() + "." + name.func_110623_a() + ".desc";
    }
}

