/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.ommina.wallpapercraft.Wallpapercraft;
import net.ommina.wallpapercraft.blocks.IDecorativeBlock;
import net.ommina.wallpapercraft.blocks.ModBlocks;
import net.ommina.wallpapercraft.items.DecorativeItem;
import net.ommina.wallpapercraft.items.Press;
import net.ommina.wallpapercraft.items.PressColour;
import net.ommina.wallpapercraft.items.PressPattern;
import net.ommina.wallpapercraft.items.PressVariant;

public class PressCraftingRecipe
implements ICraftingRecipe {
    public static final ResourceLocation NAME = Wallpapercraft.getId("presscrafting");
    public static final Serializer SERIALIZER = new Serializer();
    public static final IRecipeType<PressCraftingRecipe> RECIPE_TYPE = new IRecipeType<PressCraftingRecipe>(){

        public String toString() {
            return Wallpapercraft.getId("presscrafting").toString();
        }
    };
    private final ResourceLocation id;

    public PressCraftingRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        int patternPressCount = 0;
        int colourPressCount = 0;
        int variantPressCount = 0;
        int decorativeCount = 0;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack stack = inv.func_70301_a(k);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof PressPattern) {
                ++patternPressCount;
            } else if (stack.func_77973_b() instanceof PressColour) {
                ++colourPressCount;
            } else if (stack.func_77973_b() instanceof PressVariant) {
                ++variantPressCount;
            } else {
                if (!(stack.func_77973_b() instanceof DecorativeItem)) {
                    return false;
                }
                ++decorativeCount;
            }
            if (decorativeCount <= 1 && patternPressCount <= 1 && colourPressCount <= 1 && variantPressCount <= 1) continue;
            return false;
        }
        return decorativeCount == 1 && (patternPressCount == 1 || colourPressCount == 1 || variantPressCount == 1);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack stack;
        int i;
        String pattern = "";
        String colour = "";
        String suffix = "";
        boolean hasChanged = false;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof DecorativeItem)) continue;
            IDecorativeBlock block = ModBlocks.BLOCKS.get(stack.func_77973_b().getRegistryName().func_110623_a());
            if (block == null) {
                return ItemStack.field_190927_a;
            }
            pattern = block.getPattern();
            colour = block.getColour();
            suffix = block.getSuffix();
            break;
        }
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof Press)) continue;
            Press press = (Press)stack.func_77973_b();
            if (press instanceof PressPattern) {
                pattern = press.getVariant();
                hasChanged = true;
                continue;
            }
            if (press instanceof PressColour) {
                colour = press.getVariant();
                hasChanged = true;
                continue;
            }
            if (!(press instanceof PressVariant)) continue;
            suffix = press.getVariant();
            hasChanged = true;
        }
        if (!hasChanged) {
            return ItemStack.field_190927_a;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(Wallpapercraft.getId(pattern + colour + suffix));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof Press)) continue;
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190920_e(1);
            list.set(i, (Object)stack1);
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public String func_193358_e() {
        return "wallpapercraft";
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_222149_a;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PressCraftingRecipe> {
        private Serializer() {
        }

        @Nonnull
        public PressCraftingRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            return new PressCraftingRecipe(recipeId);
        }

        public PressCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PressCraftingRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, PressCraftingRecipe recipe) {
        }
    }
}

