/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.ommina.wallpapercraft.blocks.IDecorativeBlock;
import net.ommina.wallpapercraft.blocks.InWorldHelper;
import net.ommina.wallpapercraft.items.ModItems;
import net.ommina.wallpapercraft.items.PressColour;
import net.ommina.wallpapercraft.items.PressVariant;
import net.ommina.wallpapercraft.sounds.ModSoundType;

public class DecorativeBlockGlass
extends AbstractGlassBlock
implements IDecorativeBlock {
    private final String pattern;
    private final String colour;
    private final String suffix;

    public DecorativeBlockGlass(String pattern, String colour, int suffix, Material material, ToolType toolType, SoundType soundType, int light) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200947_a(soundType).harvestTool(toolType).harvestLevel(0).func_200943_b(0.3f).func_226896_b_().func_235861_h_().func_235838_a_(p_235464_0_ -> light));
        this.pattern = pattern;
        this.colour = colour;
        this.suffix = "-" + suffix;
        this.setRegistryName(this.getName());
    }

    @Override
    public String getName() {
        return this.pattern + this.colour + this.suffix;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getColour() {
        return this.colour;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return SoundType.field_185853_f;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.func_184614_ca().func_190926_b()) {
            return SoundType.field_185853_f;
        }
        if (player.func_184614_ca().func_77973_b() == ModItems.PAINTBRUSH || player.func_184614_ca().func_77973_b() instanceof PressColour || player.func_184614_ca().func_77973_b() instanceof PressVariant) {
            return ModSoundType.STONE;
        }
        return SoundType.field_185851_d;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        BlockState block = null;
        if (player.func_184614_ca().func_77973_b() == ModItems.PAINTBRUSH) {
            block = InWorldHelper.getIncrementedBlockColour(this);
        } else if (player.func_184614_ca().func_77973_b() instanceof PressColour) {
            block = InWorldHelper.getBlockFromColourPress(this, (PressColour)player.func_184614_ca().func_77973_b());
        } else if (player.func_184614_ca().func_77973_b() instanceof PressVariant) {
            block = InWorldHelper.getBlockFromVariantPress(this, (PressVariant)player.func_184614_ca().func_77973_b());
        }
        if (block == null) {
            return;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(pos, block, 3);
        }
    }
}

