/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.ommina.wallpapercraft.blocks.IDecorativeBlock;
import net.ommina.wallpapercraft.blocks.ModBlocks;
import net.ommina.wallpapercraft.items.DecorativeItem;
import net.ommina.wallpapercraft.items.ModItems;
import net.ommina.wallpapercraft.util.MathUtil;

public class VariantScrollRequest {
    private int delta;

    public VariantScrollRequest() {
    }

    public VariantScrollRequest(int delta) {
        this.delta = delta;
    }

    public static VariantScrollRequest fromBytes(PacketBuffer buf) {
        VariantScrollRequest packet = new VariantScrollRequest();
        packet.delta = MathUtil.clamp(buf.readInt(), -1, 1);
        return packet;
    }

    public static void handle(VariantScrollRequest packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IDecorativeBlock block;
            ItemStack stack;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            int delta = packet.delta;
            if (player.func_213453_ef() && player.func_184614_ca() != ItemStack.field_190927_a && (stack = player.func_184614_ca()).func_77973_b() instanceof DecorativeItem && (block = ModBlocks.BLOCKS.get(stack.func_77973_b().getRegistryName().func_110623_a())) != null) {
                int suffix = MathUtil.rollOver(Math.abs(Integer.parseInt(block.getSuffix())) + delta, 0, block.getColour().contains("cyan") ? 9 : 14);
                DecorativeItem item = ModItems.get(block.getPattern(), block.getColour(), suffix);
                if (item != null) {
                    player.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)item, stack.func_190916_E()));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.delta);
    }
}

