/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.ommina.wallpapercraft.blocks.IDecorativeBlock;
import net.ommina.wallpapercraft.blocks.InWorldHelper;
import net.ommina.wallpapercraft.items.ModItems;
import net.ommina.wallpapercraft.items.PressColour;
import net.ommina.wallpapercraft.items.PressVariant;
import net.ommina.wallpapercraft.sounds.ModSoundType;

public class DecorativeBlockPatterned
extends BreakableBlock
implements IDecorativeBlock {
    private static final String POSTFIX = "";
    protected final String pattern;
    protected final String colour;
    protected final String suffix;

    public DecorativeBlockPatterned(String pattern, String colour, int suffix, Material material, ToolType toolType, SoundType soundType, float hardness, int light) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200947_a(soundType).harvestTool(toolType).harvestLevel(0).func_200943_b(hardness).func_235861_h_().func_235838_a_(l -> light));
        this.pattern = pattern;
        this.colour = colour;
        this.suffix = "-" + suffix;
    }

    @Override
    public String getName() {
        return this.pattern + this.colour + this.suffix;
    }

    @Override
    public String getPostfix() {
        return POSTFIX;
    }

    @Override
    public String getNameForRegistry() {
        return this.getName() + POSTFIX;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getColour() {
        return this.colour;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, @Nullable Entity entity) {
        SoundType soundType = state.func_215695_r();
        if (!(entity instanceof PlayerEntity)) {
            return soundType;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.func_184614_ca().func_190926_b()) {
            return soundType;
        }
        if (player.func_184614_ca().func_77973_b() == ModItems.PAINTBRUSH || player.func_184614_ca().func_77973_b() instanceof PressColour || player.func_184614_ca().func_77973_b() instanceof PressVariant) {
            return ModSoundType.STONE;
        }
        return soundType;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        BlockState block = null;
        if (player.func_184614_ca().func_77973_b() == ModItems.PAINTBRUSH) {
            block = InWorldHelper.getIncrementedBlockColour(this);
        } else if (player.func_184614_ca().func_77973_b() instanceof PressColour) {
            block = InWorldHelper.getBlockFromColourPress(this, (PressColour)player.func_184614_ca().func_77973_b());
        } else if (player.func_184614_ca().func_77973_b() instanceof PressVariant) {
            block = InWorldHelper.getBlockFromVariantPress(this, (PressVariant)player.func_184614_ca().func_77973_b());
        }
        if (block == null) {
            return;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(pos, block, 3);
        }
    }
}

