/*
 * Decompiled with CFR 0.152.
 */
package net.ommina.wallpapercraft.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.ommina.wallpapercraft.blocks.IDecorativeBlock;
import net.ommina.wallpapercraft.blocks.ModBlocks;
import net.ommina.wallpapercraft.items.PressColour;
import net.ommina.wallpapercraft.items.PressVariant;

public class InWorldHelper {
    public static BlockState getIncrementedBlockColour(IDecorativeBlock blockIn) {
        Block block = (Block)ModBlocks.BLOCKS.get(InWorldHelper.getRegistryName(blockIn.getPattern(), ModBlocks.getNextColour(blockIn.getColour(), 1), blockIn.getSuffix(), blockIn));
        if (block == null) {
            block = (Block)ModBlocks.BLOCKS.get(InWorldHelper.getRegistryName(blockIn.getPattern(), ModBlocks.getNextColour(blockIn.getColour(), 2), blockIn.getSuffix(), blockIn));
        }
        if (block == null) {
            return null;
        }
        return block.func_176223_P();
    }

    public static BlockState getBlockFromColourPress(IDecorativeBlock blockIn, PressColour pressColour) {
        Block block = (Block)ModBlocks.BLOCKS.get(InWorldHelper.getRegistryName(blockIn.getPattern(), pressColour.getColour(), blockIn.getSuffix(), blockIn));
        if (block == null) {
            return null;
        }
        return block.func_176223_P();
    }

    public static BlockState getBlockFromVariantPress(IDecorativeBlock blockIn, PressVariant pressVariant) {
        Block block = (Block)ModBlocks.BLOCKS.get(InWorldHelper.getRegistryName(blockIn.getPattern(), blockIn.getColour(), pressVariant.getVariant(), blockIn));
        if (block == null) {
            return null;
        }
        return block.func_176223_P();
    }

    private static String getRegistryName(String pattern, String colour, String suffix, IDecorativeBlock block) {
        return pattern + colour + suffix + block.getPostfix();
    }
}

