/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.block;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class BlockWormBin
extends Block
implements EntityBlock {
    public BlockWormBin() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60918_(SoundType.f_56736_).m_60955_().m_60913_(2.0f, 5.0f));
        this.setRegistryName("worm_bin");
    }

    public ToolType getHarvestTool(BlockState state) {
        return ToolType.AXE;
    }

    public int getHarvestLevel(BlockState state) {
        return 0;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        boolean shiftPressed = Screen.m_96638_();
        if (shiftPressed) {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Valid food items:"));
            for (Item item : TileEntityWormBin.FOODS) {
                if (!item.m_41472_()) continue;
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("- %s: #GREEN#%s", item.m_41466_().getString(), WaterStrainerUtils.formPlural(item.m_41473_().m_38744_(), "Point", "Points"))));
            }
        } else {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("Produces Worms and Fertilizer.", "Requires vegetables or fruits.", "Press #GOLD#shift #GRAY#for more info."));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!world.m_5776_() && player instanceof ServerPlayer) {
            TileEntityWormBin tile = this.getTileEntity((LevelReader)world, pos);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)tile, (BlockPos)pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            TileEntityWormBin tile = this.getTileEntity((LevelReader)world, pos);
            if (tile != null) {
                WaterStrainerUtils.dropInventoryItems(world, pos, (IItemHandler)tile.inv);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityWormBin(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            BlockEntity tile$temp = t;
            if (tile$temp instanceof TileEntityWormBin) {
                TileEntityWormBin tile = (TileEntityWormBin)tile$temp;
                tile.serverTick();
            }
        };
    }

    public TileEntityWormBin getTileEntity(LevelReader world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityWormBin ? (TileEntityWormBin)tile : null;
    }
}

