/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.file;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.file.BaseFile;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.FileRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class FileLootTable
extends BaseFile {
    @Override
    public void init() {
        if (!this.readFile() && this.createFile()) {
            this.readFile();
        }
        this.parseData(this.localFileData);
    }

    @Override
    protected String getFilePath() {
        return "config/waterstrainer/waterstrainer_loottables.txt";
    }

    public static void printLog(int lineNumber, List<String> errors, String lineText) {
        String text = String.format("%s in line %s: %s", WaterStrainerUtils.formPlural(errors.size(), "error", "errors"), lineNumber, lineText);
        WaterStrainer.LOGGER.error("[ERROR] " + text);
        FileRegistry.LOOTTABLE_ERRORS.addFileData("");
        FileRegistry.LOOTTABLE_ERRORS.addFileData(text);
        for (String error : errors) {
            WaterStrainer.LOGGER.error(error);
            FileRegistry.LOOTTABLE_ERRORS.addFileData(error);
        }
    }

    public void parseData(List<String> content) {
        FileRegistry.LOOTTABLE_ERRORS.clearFileData();
        for (ItemStrainer strainer : ItemRegistry.strainers) {
            strainer.LOOT_TABLE.clearLootTable();
        }
        if (content == null || content.isEmpty()) {
            WaterStrainer.LOGGER.warn("Could not parse loot table. Received data was null or empty.");
            FileRegistry.LOOTTABLE_ERRORS.addFileData("Could not parse loot table. Received data was null or empty.");
            FileRegistry.LOOTTABLE_ERRORS.saveFileData();
            return;
        }
        WaterStrainer.LOGGER.info("--- LootTable import: Start ---");
        int lineNumber = 0;
        ArrayList<String> log = new ArrayList<String>();
        for (String line : content) {
            ++lineNumber;
            if (line.startsWith("//") || line.startsWith("#")) continue;
            String lineData = Tags.COPY_LOOT_DATA.getTagData(line);
            if (lineData != null) {
                ItemStrainer parent;
                String childStr = Tags.CHILD.getTagData(lineData);
                ItemStrainer child = childStr != null ? ItemRegistry.getStrainer(childStr) : null;
                String parentStr = Tags.PARENT.getTagData(lineData);
                ItemStrainer itemStrainer = parent = parentStr != null ? ItemRegistry.getStrainer(parentStr) : null;
                if (childStr == null) {
                    log.add(String.format("<child> tag is missing", childStr));
                } else if (child == null) {
                    log.add(String.format("<child> '%s' is invalid. Use a valid strainer registry name (without modid)", childStr));
                }
                if (parentStr == null) {
                    log.add(String.format("<parent> tag is missing", parentStr));
                } else if (parent == null) {
                    log.add(String.format("Cannot <copy> loot from <parent> '%s' - it does not exist. Use a valid strainer registry name (without modid)", parentStr));
                } else if (Objects.equals(childStr, parentStr)) {
                    log.add(String.format("<child> '%s' cannot <copy> itself. Define another strainer as <parent>.", childStr));
                }
                if (log.size() == 0) {
                    child.LOOT_TABLE = LootTable.getCopyOfLootTable(parent.LOOT_TABLE);
                    WaterStrainer.LOGGER.info(String.format("[SUCCESS] Line %s: Copied loot table data from <parent> '%s' to <child> '%s'", lineNumber, parentStr, childStr));
                    continue;
                }
                FileLootTable.printLog(lineNumber, log, lineData);
                log.clear();
                continue;
            }
            lineData = Tags.ADD_LOOT_DATA.getTagData(line);
            if (lineData == null) continue;
            String strainerStr = Tags.STRAINER.getTagData(lineData);
            ItemStrainer strainer = strainerStr != null ? ItemRegistry.getStrainer(strainerStr) : null;
            String group = Tags.GROUP.getTagData(lineData);
            String chanceStr = Tags.CHANCE.getTagData(lineData);
            int chance = chanceStr == null ? 100 : (WaterStrainerUtils.isInt(chanceStr) ? Integer.parseInt(chanceStr) : 0);
            String itemStr = Tags.ITEM.getTagData(lineData);
            Item item = WaterStrainerUtils.getItemByName(itemStr);
            String countStr = Tags.COUNT.getTagData(lineData);
            int count = countStr == null ? 1 : (WaterStrainerUtils.isInt(countStr) ? Integer.parseInt(countStr) : 0);
            String subchanceStr = Tags.SUBCHANCE.getTagData(lineData);
            int subchance = subchanceStr == null ? 100 : (WaterStrainerUtils.isInt(subchanceStr) ? Integer.parseInt(subchanceStr) : 0);
            Object nbtStr = Tags.NBT.getTagData(lineData);
            CompoundTag nbt = null;
            if (strainerStr == null) {
                log.add(String.format("<strainer> tag is missing", strainerStr));
            } else if (strainer == null) {
                log.add(String.format("<strainer> '%s' is invalid. Use a valid strainer registry name (without modid)", strainerStr));
            }
            if (chance < 1) {
                log.add(String.format("<chance> '%s' is invalid. Must be a positive integer in range of: 1 to %s", chanceStr, Integer.MAX_VALUE));
            }
            if (itemStr == null) {
                log.add(String.format("<item> tag is missing. Use a valid registry name or the '%s' keyword", "$BLANK$"));
            } else if (item == null && !Objects.equals(itemStr, "$BLANK$")) {
                log.add(String.format("<item> '%s' does not exist", itemStr));
            }
            if (count < 1) {
                log.add(String.format("<count> '%s' is invalid. Must be a positive integer in range of: 1 to %s", countStr, Integer.MAX_VALUE));
            }
            if (subchance < 1) {
                log.add(String.format("<subchance> '%s' is invalid. Must be a positive integer in range of: 1 to %s", subchanceStr, Integer.MAX_VALUE));
            }
            if (nbtStr != null) {
                try {
                    if (!((String)nbtStr).startsWith("{") && !((String)nbtStr).endsWith("}")) {
                        nbtStr = "{" + (String)nbtStr + "}";
                    }
                    nbt = TagParser.m_129359_((String)nbtStr);
                }
                catch (CommandSyntaxException e) {
                    log.add(String.format("<nbt> could not be parsed", nbtStr));
                }
            }
            if (log.size() == 0) {
                ItemStack loot;
                ItemStack itemStack = loot = item != null ? new ItemStack((ItemLike)item, count) : ItemStack.f_41583_;
                if (nbt != null && !loot.m_41619_()) {
                    loot.m_41751_(nbt);
                }
                strainer.LOOT_TABLE.addLootToTable(group, loot, chance, subchance);
                WaterStrainer.LOGGER.info(String.format("[SUCCESS] Line %s: Added loot to table: Strainer: %s - Item: %s - Count: %s - Group: %s - Chance: %s - Subchance: %s - NBT: %s", lineNumber, strainerStr, itemStr, count, group, chance, subchance, nbtStr));
                continue;
            }
            FileLootTable.printLog(lineNumber, log, lineData);
            log.clear();
        }
        WaterStrainer.LOGGER.info("Result: Found " + WaterStrainerUtils.formPlural(FileRegistry.LOOTTABLE_ERRORS.getLocalFileData().size(), "error", "errors"));
        WaterStrainer.LOGGER.info("--- LootTable import: End ---");
        if (FileRegistry.LOOTTABLE_ERRORS.getLocalFileData().size() > 0) {
            FileRegistry.LOOTTABLE_ERRORS.saveFileData();
        }
    }

    @Override
    protected List<String> getDefaultContent() {
        return Arrays.asList("// You can add custom loot entries by using xml-like tags. The relevant data needs to be surrounded by <...> and </...>", "// Looking at the default table will give you some examples", "// Adding a new entry requires at least the <strainer> and <item> tag (surrounded by <add>). Use <chance> to set item rarity (higher chance = more likely to drop)", "// To copy the current loot table to another strainer use the <parent> and <child> tag (surrounded by <copy>)", "// Please use a new line for every new entry or command, since loot entries can not spread over multiple lines!", "// For more info: http://bit.ly/waterstrainer", "", "// Version of this config", "// This is an internal value for the file parser, don't change it", "<configversion>1</configversion>", "", "// Survivalist's Strainer", "<add><strainer>strainer_survivalist</strainer> <chance>30</chance> <item>minecraft:sand</item></add>", "<add><strainer>strainer_survivalist</strainer> <chance>20</chance> <item>minecraft:dirt</item></add>", "<add><strainer>strainer_survivalist</strainer> <chance>20</chance> <item>minecraft:stick</item></add>", "<add><strainer>strainer_survivalist</strainer> <chance>15</chance> <item>minecraft:clay_ball</item></add>", "<add><strainer>strainer_survivalist</strainer> <chance>13</chance> <item>minecraft:gravel</item></add>", "<add><strainer>strainer_survivalist</strainer> <group>NUGGET</group> <chance>2</chance> <item>minecraft:iron_nugget</item> <subchance>75</subchance></add>", "<add><strainer>strainer_survivalist</strainer> <group>NUGGET</group> <chance>2</chance> <item>minecraft:gold_nugget</item> <subchance>25</subchance></add>", "", "<copy><child>strainer_survivalist_solid</child> <parent>strainer_survivalist</parent></copy>", "<copy><child>strainer_survivalist_reinforced</child> <parent>strainer_survivalist</parent></copy>", "", "// Fisherman's Strainer", "<add><strainer>strainer_fisherman</strainer> <group>FISH</group> <chance>100</chance> <item>minecraft:cod</item> <subchance>60</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>FISH</group> <chance>100</chance> <item>minecraft:salmon</item> <subchance>25</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>FISH</group> <chance>100</chance> <item>minecraft:pufferfish</item> <subchance>13</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>FISH</group> <chance>100</chance> <item>minecraft:tropical_fish</item> <subchance>2</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:stick</item> <subchance>22</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:string</item> <subchance>13</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:leather</item> <subchance>13</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:rotten_flesh</item> <subchance>13</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:bone</item> <subchance>13</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:glass_bottle</item> <subchance>12</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:lily_pad</item> <subchance>7</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <group>JUNK</group> <chance>30</chance> <item>minecraft:vine</item> <subchance>7</subchance></add>", "<add><strainer>strainer_fisherman</strainer> <chance>1</chance> <item>minecraft:enchanted_book</item></add>", "<add><strainer>strainer_fisherman</strainer> <chance>69</chance> <item>$BLANK$</item></add>", "", "<copy><child>strainer_fisherman_solid</child> <parent>strainer_fisherman</parent></copy>", "<copy><child>strainer_fisherman_reinforced</child> <parent>strainer_fisherman</parent></copy>");
    }

    public static enum Tags {
        ADD_LOOT_DATA("add"),
        COPY_LOOT_DATA("copy"),
        CONFIGVERSION("configversion"),
        STRAINER("strainer"),
        GROUP("group"),
        CHANCE("chance"),
        ITEM("item"),
        COUNT("count"),
        SUBCHANCE("subchance"),
        NBT("nbt"),
        CHILD("child"),
        PARENT("parent");

        public final String tagname;

        private Tags(String tagname) {
            this.tagname = tagname;
        }

        public String getTagData(String input) {
            return input != null ? StringUtils.substringBetween((String)input, (String)String.format("<%s>", this.tagname), (String)String.format("</%s>", this.tagname)) : null;
        }
    }
}

