/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mods.waterstrainer.registry.FileRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketSyncLootTable {
    private List<String> lootTableData = new ArrayList<String>();
    private int lootTableSize = 0;

    public PacketSyncLootTable(List<String> data) {
        this.lootTableSize = data == null ? 0 : data.size();
        this.lootTableData = data;
    }

    public static void writePacket(PacketSyncLootTable packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.lootTableSize);
        if (packet.lootTableSize > 0) {
            for (String data : packet.lootTableData) {
                buf.m_130070_(data);
            }
        }
    }

    public static PacketSyncLootTable readPacket(FriendlyByteBuf buf) {
        int length = buf.readInt();
        ArrayList<String> list = new ArrayList<String>();
        if (length > 0) {
            for (int i = 1; i <= length; ++i) {
                list.add(buf.m_130277_());
            }
        }
        return new PacketSyncLootTable(list);
    }

    public static class Handler {
        public static void handlePacket(PacketSyncLootTable packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> FileRegistry.LOOTTABLE.parseData(packet.lootTableData));
            ctx.get().setPacketHandled(true);
        }
    }
}

