/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mods.waterstrainer.item.ItemBaitPot;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemFertilizer;
import mods.waterstrainer.item.ItemGardenTrowel;
import mods.waterstrainer.item.ItemMesh;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.item.ItemSuperWorm;
import mods.waterstrainer.item.ItemWorm;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemRegistry {
    public static List<ItemStrainer> strainers = new ArrayList<ItemStrainer>();
    public static ItemStrainer strainer_survivalist;
    public static ItemStrainer strainer_survivalist_solid;
    public static ItemStrainer strainer_survivalist_reinforced;
    public static ItemStrainer strainer_fisherman;
    public static ItemStrainer strainer_fisherman_solid;
    public static ItemStrainer strainer_fisherman_reinforced;
    public static ItemMesh string_mesh;
    public static ItemMesh iron_mesh;
    public static ItemMesh obsidian_mesh;
    public static ItemEfficiencyMeter efficiency_meter;
    public static ItemWorm worm;
    public static ItemSuperWorm super_worm;
    public static ItemBaitPot bait_pot;
    public static ItemGardenTrowel garden_trowel;
    public static ItemFertilizer fertilizer;

    public static ItemStrainer addStrainer(ItemStrainer strainer) {
        strainers.add(strainer);
        return strainer;
    }

    public static ItemStrainer getStrainer(String registryName) {
        for (ItemStrainer strainer : strainers) {
            if (!Objects.equals(strainer.TYPE.regname, registryName)) continue;
            return strainer;
        }
        return null;
    }

    public static List<ItemStrainer> getStrainerList(ItemStrainer.StrainerTier tier) {
        ArrayList<ItemStrainer> list = new ArrayList<ItemStrainer>();
        for (ItemStrainer strainer : strainers) {
            if (strainer.TYPE.tier != tier) continue;
            list.add(strainer);
        }
        return list;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registration {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            string_mesh = new ItemMesh(ItemMesh.EnumSubtype.STRING_MESH);
            registry.register((IForgeRegistryEntry)string_mesh);
            iron_mesh = new ItemMesh(ItemMesh.EnumSubtype.IRON_MESH);
            registry.register((IForgeRegistryEntry)iron_mesh);
            obsidian_mesh = new ItemMesh(ItemMesh.EnumSubtype.OBSIDIAN_MESH);
            registry.register((IForgeRegistryEntry)obsidian_mesh);
            worm = new ItemWorm();
            registry.register((IForgeRegistryEntry)worm);
            super_worm = new ItemSuperWorm();
            registry.register((IForgeRegistryEntry)super_worm);
            bait_pot = new ItemBaitPot();
            registry.register((IForgeRegistryEntry)bait_pot);
            garden_trowel = new ItemGardenTrowel();
            registry.register((IForgeRegistryEntry)garden_trowel);
            efficiency_meter = new ItemEfficiencyMeter();
            registry.register((IForgeRegistryEntry)efficiency_meter);
            fertilizer = new ItemFertilizer();
            registry.register((IForgeRegistryEntry)fertilizer);
            strainer_survivalist = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST));
            registry.register((IForgeRegistryEntry)strainer_survivalist);
            strainer_survivalist_solid = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_SOLID));
            registry.register((IForgeRegistryEntry)strainer_survivalist_solid);
            strainer_survivalist_reinforced = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_SURVIVALIST_REINFORCED));
            registry.register((IForgeRegistryEntry)strainer_survivalist_reinforced);
            strainer_fisherman = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN));
            registry.register((IForgeRegistryEntry)strainer_fisherman);
            strainer_fisherman_solid = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_SOLID));
            registry.register((IForgeRegistryEntry)strainer_fisherman_solid);
            strainer_fisherman_reinforced = ItemRegistry.addStrainer(new ItemStrainer(ItemStrainer.EnumSubtype.STRAINER_FISHERMAN_REINFORCED));
            registry.register((IForgeRegistryEntry)strainer_fisherman_reinforced);
        }
    }
}

