/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.tileentity;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityWormBin
extends BlockEntity
implements MenuProvider {
    public InventoryHandler inv = this.initInventory();
    private int curWormProg = 0;
    private int curFertProg = 0;
    public static final int MAX_WORM_PROG = 4;
    public static final int MAX_FERT_PROG = 20;
    public static final List<Item> FOODS = Arrays.asList(Items.f_42620_, Items.f_41910_, Items.f_42732_, Items.f_42575_, Items.f_42780_, Items.f_42619_, Items.f_42410_, Items.f_42730_);
    private final ContainerData syncValues = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntityWormBin.this.curWormProg;
                }
                case 1: {
                    return TileEntityWormBin.this.curFertProg;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityWormBin.this.curWormProg = value;
                    break;
                }
                case 1: {
                    TileEntityWormBin.this.curFertProg = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private final LazyOptional<IItemHandler> capItemHandler = LazyOptional.of(() -> this.createCapabilityHandler());

    public TileEntityWormBin(BlockPos pos, BlockState state) {
        super(WaterStrainer.tile_worm_bin, pos, state);
    }

    private InventoryHandler initInventory() {
        return new InventoryHandler(this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inv = this.initInventory();
        this.inv.deserializeNBT(nbt);
        this.curWormProg = nbt.m_128451_("CurWormProg");
        this.curFertProg = nbt.m_128451_("CurFertProg");
    }

    public CompoundTag m_6945_(CompoundTag nbt) {
        super.m_6945_(nbt);
        nbt.m_128391_(this.inv.serializeNBT());
        nbt.m_128405_("CurWormProg", this.curWormProg);
        nbt.m_128405_("CurFertProg", this.curFertProg);
        return nbt;
    }

    protected IItemHandler createCapabilityHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inv}){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return slot == 0 && this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 1 || slot == 2 ? super.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
            }
        };
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.capItemHandler);
    }

    public static boolean isItemValidFood(ItemStack stack) {
        return FOODS.contains(stack.m_41720_()) && stack.m_41720_().m_41472_();
    }

    public ItemStack getFood() {
        return this.inv.getStackInSlot(0);
    }

    public ItemStack getWorm() {
        return this.inv.getStackInSlot(1);
    }

    public ItemStack getFertilizer() {
        return this.inv.getStackInSlot(2);
    }

    public void serverTick() {
        ItemStack foodStack = this.getFood();
        if (!foodStack.m_41619_() && foodStack.m_41614_()) {
            ItemStack wormStack = this.getWorm();
            ItemStack fertStack = this.getFertilizer();
            if (wormStack.m_41613_() < wormStack.m_41741_() && fertStack.m_41613_() < fertStack.m_41741_()) {
                int stacksize;
                FoodProperties foodprop = foodStack.m_41720_().m_41473_();
                this.curWormProg += foodprop.m_38744_();
                this.curFertProg += foodprop.m_38744_();
                if (this.curWormProg >= 4) {
                    stacksize = Math.min(wormStack.m_41741_(), wormStack.m_41613_() + this.curWormProg / 4);
                    if (!wormStack.m_41619_()) {
                        wormStack.m_41764_(stacksize);
                    } else {
                        this.inv.setStackInSlot(1, new ItemStack((ItemLike)ItemRegistry.worm, stacksize));
                    }
                    this.curWormProg %= 4;
                }
                if (this.curFertProg >= 20) {
                    stacksize = Math.min(fertStack.m_41741_(), fertStack.m_41613_() + this.curFertProg / 20);
                    if (!fertStack.m_41619_()) {
                        fertStack.m_41764_(stacksize);
                    } else {
                        this.inv.setStackInSlot(2, new ItemStack((ItemLike)ItemRegistry.fertilizer, stacksize));
                    }
                    this.curFertProg %= 20;
                }
                foodStack.m_41774_(1);
                this.m_6596_();
            }
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory invIn, Player playerIn) {
        return new ContainerWormBin(id, invIn, this.m_58899_(), this.syncValues);
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.waterstrainer.worm_bin");
    }

    public class InventoryHandler
    extends ItemStackHandler {
        private final TileEntityWormBin tile;

        private InventoryHandler(TileEntityWormBin te) {
            super(3);
            this.tile = te;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.tile.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot == 0) {
                return TileEntityWormBin.isItemValidFood(stack);
            }
            return true;
        }
    }
}

