/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.world.item.ItemStack;

public class LootTable {
    public int randomCatNameIndex = 0;
    public int lootTableMinIndex = 0;
    public int lootTableMaxIndex = 0;
    public final List<Category> categories = new ArrayList<Category>();
    public static final String BLANK_KEYWORD = "$BLANK$";

    public void clearLootTable() {
        this.categories.clear();
        this.randomCatNameIndex = 0;
        this.lootTableMinIndex = 0;
        this.lootTableMaxIndex = 0;
    }

    public static LootTable getCopyOfLootTable(LootTable source) {
        LootTable table = new LootTable();
        table.randomCatNameIndex = source.randomCatNameIndex;
        table.lootTableMinIndex = source.lootTableMinIndex;
        table.lootTableMaxIndex = source.lootTableMaxIndex;
        table.categories.addAll(source.categories);
        return table;
    }

    public void addLootToTable(String categoryName, ItemStack stack, int catRarity, int itemRarity) {
        Category cat = null;
        if (categoryName == null) {
            categoryName = "__randomGeneratedCat" + Integer.toString(this.randomCatNameIndex);
            ++this.randomCatNameIndex;
        } else {
            cat = this.getCategory((String)categoryName);
        }
        if (cat == null) {
            int position = 0;
            for (Category c : this.categories) {
                if (catRarity > c.rarity) break;
                ++position;
            }
            this.lootTableMaxIndex = this.lootTableMinIndex + catRarity - 1;
            cat = new Category((String)categoryName, catRarity, this.lootTableMinIndex, this.lootTableMaxIndex);
            this.lootTableMinIndex = this.lootTableMaxIndex + 1;
            this.categories.add(position, cat);
        }
        cat.addLootToCategory(stack, itemRarity);
    }

    public Category getRandomCategoryFromTable() {
        if (this.lootTableMinIndex > 0 && this.lootTableMaxIndex > 0) {
            int randomIndex = new Random().nextInt(this.lootTableMinIndex);
            return this.getCategoryInRange(randomIndex);
        }
        return null;
    }

    public ItemStack getRandomLootFromTable() {
        int randomIndex;
        Category randomCat;
        ItemStack stack = ItemStack.f_41583_;
        if (this.lootTableMinIndex > 0 && this.lootTableMaxIndex > 0 && (randomCat = this.getCategoryInRange(randomIndex = new Random().nextInt(this.lootTableMinIndex))) != null) {
            return randomCat.getRandomLootFromCategory();
        }
        return stack;
    }

    private Category getCategory(String categoryName) {
        for (Category cat : this.categories) {
            if (!Objects.equals(cat.name, categoryName)) continue;
            return cat;
        }
        return null;
    }

    private Category getCategoryInRange(int rangeIndex) {
        for (Category cat : this.categories) {
            if (rangeIndex < cat.categoryMinIndex || rangeIndex > cat.categoryMaxIndex) continue;
            return cat;
        }
        return null;
    }

    public List<ItemStack> getLootTableAsList(boolean excludeEmptyStacks) {
        ArrayList<ItemStack> stacklist = new ArrayList<ItemStack>();
        for (Category cat : this.categories) {
            for (Loot loot : cat.items) {
                ItemStack stack = loot.stack;
                if (stack.m_41619_() && excludeEmptyStacks) continue;
                stacklist.add(stack);
            }
        }
        return stacklist;
    }

    public static class Category {
        public final String name;
        public final int rarity;
        public final int categoryMinIndex;
        public final int categoryMaxIndex;
        public final List<Loot> items = new ArrayList<Loot>();

        public Category(String name, int rarity, int minIndex, int maxIndex) {
            this.name = name;
            this.rarity = rarity;
            this.categoryMinIndex = minIndex;
            this.categoryMaxIndex = maxIndex;
        }

        public void addLootToCategory(ItemStack stack, int lootRarity) {
            if (lootRarity > 0) {
                int newLootIndex = this.items.size() > 0 ? this.items.get((int)(this.items.size() - 1)).lootMaxIndex + lootRarity : lootRarity - 1;
                this.items.add(new Loot(stack, lootRarity, newLootIndex));
            }
        }

        public ItemStack getRandomLootFromCategory() {
            if (this.items.size() > 0) {
                int randomIndex = new Random().nextInt(this.items.get((int)(this.items.size() - 1)).lootMaxIndex + 1);
                for (Loot loot : this.items) {
                    if (randomIndex > loot.lootMaxIndex) continue;
                    return loot.stack.m_41777_();
                }
            }
            return ItemStack.f_41583_;
        }
    }

    public static class Loot {
        public final ItemStack stack;
        public final int subRarity;
        public final int lootMaxIndex;

        public Loot(ItemStack stack, int subRarity, int maxIndex) {
            this.stack = stack;
            this.subRarity = subRarity;
            this.lootMaxIndex = maxIndex;
        }
    }
}

