/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.BooleanSupplier;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.IConditionSerializer;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static ForgeConfigSpec.IntValue IDLE_TIME;
    public static ForgeConfigSpec.IntValue IDLE_TIME_DEVIATION;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_SOLID;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_SURVIVALIST_REINFORCED;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_SOLID;
    public static ForgeConfigSpec.IntValue DURABILITY_STRAINER_FISHERMAN_REINFORCED;
    public static ForgeConfigSpec.IntValue BONUS_SOLID_EFFICIENCY;
    public static ForgeConfigSpec.IntValue BONUS_REINFORCED_EFFICIENCY;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_EFFICIENCY;
    public static ForgeConfigSpec.BooleanValue MISC_ENABLE_ENCHANTING;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST_SOLID;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_SURVIVALIST_REINFORCED;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN_SOLID;
    public static ForgeConfigSpec.BooleanValue ENABLE_STRAINER_FISHERMAN_REINFORCED;

    public Config(ForgeConfigSpec.Builder builder) {
        builder.push("IdleTime");
        IDLE_TIME = builder.comment("Time (in seconds) until a strainer catches an item. [Default: 30]").defineInRange("idle_time", 30, 0, 0x6666666);
        IDLE_TIME_DEVIATION = builder.comment("Adds a deviation to the idle time to make it more random. [Default: 5]").defineInRange("idle_time_deviation", 5, 0, 0x6666666);
        builder.pop();
        builder.comment("Set the max durability (uses) for each strainer type.\nUse 0 for infinite durability.\nDefault:\n- Normal: 120\n- Solid: 720\n- Reinforced: 8640").push("Durability");
        DURABILITY_STRAINER_SURVIVALIST = builder.defineInRange("durability_strainer_survivalist", 120, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_SURVIVALIST_SOLID = builder.defineInRange("durability_strainer_survivalist_solid", 720, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_SURVIVALIST_REINFORCED = builder.defineInRange("durability_strainer_survivalist_reinforced", 8640, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN = builder.defineInRange("durability_strainer_fisherman", 120, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN_SOLID = builder.defineInRange("durability_strainer_fisherman_solid", 720, 0, Integer.MAX_VALUE);
        DURABILITY_STRAINER_FISHERMAN_REINFORCED = builder.defineInRange("durability_strainer_fisherman_reinforced", 8640, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Bonus");
        BONUS_SOLID_EFFICIENCY = builder.comment("Bonus efficiency (in %) for Solid Strainers. Use 0 to disable bonus efficiency. [Default: 10]").defineInRange("bonus_solid_efficiency", 10, 0, Integer.MAX_VALUE);
        BONUS_REINFORCED_EFFICIENCY = builder.comment("Bonus efficiency (in %) for Reinforced Strainers. Use 0 to disable bonus efficiency. [Default: 25]").defineInRange("bonus_reinforced_efficiency", 25, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Misc");
        MISC_ENABLE_EFFICIENCY = builder.comment("Strainers are more or less efficient based on their placement (liquid height, biome, adjacent strainers).\nBonus efficiency from strainer type and enchantments still apply. [Default: true]").define("misc_enable_efficiency", true);
        MISC_ENABLE_ENCHANTING = builder.comment("Reinforced Strainers (Tier 3) can be enchanted. [Default: true]").define("misc_enable_enchanting", true);
        builder.pop();
        builder.push("Recipes");
        ENABLE_STRAINER_SURVIVALIST = builder.define("enable_strainer_survivalist", true);
        ENABLE_STRAINER_SURVIVALIST_SOLID = builder.define("enable_strainer_survivalist_solid", true);
        ENABLE_STRAINER_SURVIVALIST_REINFORCED = builder.define("enable_strainer_survivalist_reinforced", true);
        ENABLE_STRAINER_FISHERMAN = builder.define("enable_strainer_fisherman", true);
        ENABLE_STRAINER_FISHERMAN_SOLID = builder.define("enable_strainer_fisherman_solid", true);
        ENABLE_STRAINER_FISHERMAN_REINFORCED = builder.define("enable_strainer_fisherman_reinforced", true);
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class CraftingConditionFactory
    implements IConditionSerializer {
        public BooleanSupplier parse(JsonObject json) {
            String setting = JsonUtils.func_151200_h((JsonObject)json, (String)"setting");
            return () -> CraftingConditionFactory.isEnabled(setting);
        }

        public static boolean isEnabled(String setting) {
            switch (setting) {
                case "strainer_survivalist": {
                    return (Boolean)ENABLE_STRAINER_SURVIVALIST.get();
                }
                case "strainer_survivalist_solid": {
                    return (Boolean)ENABLE_STRAINER_SURVIVALIST_SOLID.get();
                }
                case "strainer_survivalist_reinforced": {
                    return (Boolean)ENABLE_STRAINER_SURVIVALIST_REINFORCED.get();
                }
                case "strainer_fisherman": {
                    return (Boolean)ENABLE_STRAINER_FISHERMAN.get();
                }
                case "strainer_fisherman_solid": {
                    return (Boolean)ENABLE_STRAINER_FISHERMAN_SOLID.get();
                }
                case "strainer_fisherman_reinforced": {
                    return (Boolean)ENABLE_STRAINER_FISHERMAN_REINFORCED.get();
                }
            }
            throw new JsonSyntaxException("Invalid setting name '" + setting + "'");
        }
    }
}

