/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.block;

import java.util.List;
import javax.annotation.Nullable;
import mods.waterstrainer.item.ItemEfficiencyMeter;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class BlockStrainerBase
extends Block {
    public static final IntegerProperty MODELID = IntegerProperty.func_177719_a((String)"modelid", (int)0, (int)7);

    public BlockStrainerBase() {
        super(Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200947_a(SoundType.field_185848_a).func_200948_a(2.0f, 5.0f));
        this.setRegistryName("strainer_base");
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)MODELID, (Comparable)Integer.valueOf(0)));
    }

    public ToolType getHarvestTool(IBlockState state) {
        return ToolType.AXE;
    }

    public int getHarvestLevel(IBlockState state) {
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{MODELID});
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TextComponentString("Generates items while in water."));
        tooltip.add((ITextComponent)new TextComponentString("Requires a strainer and water on top."));
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player instanceof EntityPlayerMP) {
            ItemStack heldItemStack = player.func_184586_b(hand);
            TileEntityStrainer tile = this.getTileEntity(world, pos);
            if (heldItemStack.func_77973_b() instanceof ItemStrainer && tile != null) {
                int slot = player.field_71071_by.field_70461_c;
                if (tile.inv.getStackInSlot(0) == ItemStack.field_190927_a) {
                    tile.inv.setStackInSlot(0, heldItemStack);
                    player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                    return true;
                }
            }
            if (heldItemStack.func_77973_b() instanceof ItemEfficiencyMeter) {
                if (!world.func_204610_c(pos.func_177984_a()).func_206884_a(FluidTags.field_206959_a)) {
                    WaterStrainerUtils.sendChatMessage((ICommandSource)player, TextFormatting.RED + "Strainer has no water!");
                    return true;
                }
                if (tile != null) {
                    float efficiency = tile.calculateEfficiencyBonus();
                    if (efficiency == 0.0f) {
                        WaterStrainerUtils.sendChatMessage((ICommandSource)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.YELLOW + "0%");
                    } else if (efficiency > 0.0f) {
                        WaterStrainerUtils.sendChatMessage((ICommandSource)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.GREEN + "+" + (int)efficiency + "%");
                    } else {
                        WaterStrainerUtils.sendChatMessage((ICommandSource)player, TextFormatting.GOLD + "Bonus Efficiency: " + TextFormatting.RED + (int)efficiency + "%");
                    }
                    return true;
                }
            }
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)tile, (BlockPos)tile.func_174877_v());
        }
        return true;
    }

    public static void updateModel(TileEntityStrainer tile) {
        if (tile != null) {
            if (BlockStrainerBase.canStayAt((IWorldReaderBase)tile.func_145831_w(), tile.func_174877_v())) {
                ItemStack strainerStack = tile.inv.getStackInSlot(0);
                if (strainerStack.func_77973_b() instanceof ItemStrainer) {
                    BlockStrainerBase.setState(tile.func_145831_w(), tile.func_174877_v(), ((ItemStrainer)strainerStack.func_77973_b()).MODEL);
                } else {
                    BlockStrainerBase.setState(tile.func_145831_w(), tile.func_174877_v(), Model.BASE_DEFAULT);
                }
            } else {
                BlockStrainerBase.setState(tile.func_145831_w(), tile.func_174877_v(), Model.BASE_BLOCKED);
            }
        }
    }

    public static void setState(World world, BlockPos pos, Model model) {
        IBlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() != BlockRegistry.strainer_base) {
            return;
        }
        int newState = model.id;
        int oldState = (Integer)state.func_177229_b((IProperty)MODELID);
        if (newState != oldState) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)MODELID, (Comparable)Integer.valueOf(newState)));
        }
    }

    public static boolean canStayAt(IWorldReaderBase world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
        Material material = state.func_185904_a();
        return material == Material.field_151579_a || material.func_76224_d();
    }

    public static boolean isStrainerInLiquid(World world, BlockPos pos) {
        return world.func_204610_c(pos.func_177984_a()).func_206884_a(FluidTags.field_206959_a);
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return BlockStrainerBase.canStayAt(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        BlockStrainerBase.updateModel(this.getTileEntity(world, pos));
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntityStrainer tile = this.getTileEntity(world, pos);
            if (tile != null) {
                WaterStrainerUtils.dropInventoryItems(world, pos, (IItemHandler)tile.inv);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityStrainer();
    }

    public TileEntityStrainer getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityStrainer ? (TileEntityStrainer)tile : null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum Model {
        BASE_DEFAULT(0),
        BASE_BLOCKED(1),
        STRAINER_SURVIVALIST(2),
        STRAINER_SURVIVALIST_SOLID(3),
        STRAINER_SURVIVALIST_REINFORCED(4),
        STRAINER_FISHERMAN(5),
        STRAINER_FISHERMAN_SOLID(6),
        STRAINER_FISHERMAN_REINFORCED(7);

        public final int id;

        private Model(int id) {
            this.id = id;
        }
    }
}

