/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import java.util.Arrays;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiStrainer
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/strainer_base.png");
    private final TileEntityStrainer tile;
    private final InventoryPlayer playerInventory;

    public GuiStrainer(InventoryPlayer playerInventory, TileEntityStrainer tileEntity) {
        super((Container)new ContainerStrainer(playerInventory, tileEntity));
        this.playerInventory = playerInventory;
        this.tile = tileEntity;
        this.field_147000_g = 226;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null) {
            int slotIndex = slot.field_75222_d;
            if (slot.func_75216_d()) {
                return;
            }
            if (slotIndex == 0) {
                this.drawHoveringText(Arrays.asList("Strainer Slot"), mouseX, mouseY, this.field_146289_q);
            } else if (slotIndex == 28) {
                this.drawHoveringText(Arrays.asList("Bait Slot"), mouseX, mouseY, this.field_146289_q);
            } else if (slotIndex == 29) {
                this.drawHoveringText(Arrays.asList("Bait Pot Slot"), mouseX, mouseY, this.field_146289_q);
            }
        }
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        EnumBaitStatus status = this.getBaitStatus();
        if (this.isMouseHovering(mouseX, mouseY, guiX + 57, guiY + 42, 12, 12)) {
            if (status == EnumBaitStatus.REDUNDANT) {
                this.drawHoveringText(Arrays.asList(TextFormatting.RED + "Bait redundant", "This strainer does", "not need any bait!"), mouseX, mouseY, this.field_146289_q);
            } else if (status == EnumBaitStatus.REQUIRED) {
                this.drawHoveringText(Arrays.asList(TextFormatting.RED + "Bait required", "This strainer requires bait!"), mouseX, mouseY, this.field_146289_q);
            }
        } else if (this.isMouseHovering(mouseX, mouseY, guiX + 155, guiY + 5, 16, 16)) {
            this.drawHoveringText(Arrays.asList(WaterStrainerUtils.ctext("#RED#Show Recipes"), WaterStrainerUtils.ctext("Not implemented yet, but soon\u2122")), mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tile.func_200200_C_().func_150254_d();
        this.field_146289_q.func_211126_b(s, (float)(this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.field_146289_q.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.inv.getStackInSlot(0).func_190926_b()) {
            this.func_73729_b(k + 80, l + 21, 176, 0, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(28).func_190926_b()) {
            this.func_73729_b(k + 70, l + 41, 176, 32, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(29).func_190926_b()) {
            this.func_73729_b(k + 90, l + 41, 176, 16, 16, 16);
        }
        if (this.getBaitStatus() != EnumBaitStatus.NONE) {
            this.func_73729_b(k + 55, l + 43, 192, 0, 12, 12);
        }
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    private EnumBaitStatus getBaitStatus() {
        ItemStack stack = this.tile.inv.getStackInSlot(0);
        ItemStack bait = this.tile.inv.getStackInSlot(28);
        if (stack.func_77973_b() instanceof ItemStrainer) {
            ItemStrainer strainer = (ItemStrainer)stack.func_77973_b();
            if (strainer.TYPE.category != ItemStrainer.StrainerCategory.FISHER) {
                if (!bait.func_190926_b()) {
                    return EnumBaitStatus.REDUNDANT;
                }
            } else if (bait.func_190926_b()) {
                return EnumBaitStatus.REQUIRED;
            }
        }
        return EnumBaitStatus.NONE;
    }

    private static enum EnumBaitStatus {
        NONE,
        REDUNDANT,
        REQUIRED;

    }
}

