/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class ItemStrainer
extends Item {
    private int curTooltipIndex = 0;
    private static Random rand = new Random();
    private long updateTime = System.currentTimeMillis();
    private List<String> tooltipData = new ArrayList<String>();
    public final ForgeConfigSpec.IntValue DURABILITY;
    public final EnumSubtype TYPE;
    public LootTable LOOT_TABLE;
    public final BlockStrainerBase.Model MODEL;

    public ItemStrainer(EnumSubtype strainerType, ForgeConfigSpec.IntValue durability) {
        super(new Item.Properties().func_200916_a(WaterStrainer.tabWaterStrainer).func_200917_a(1));
        this.setRegistryName(strainerType.regname);
        this.TYPE = strainerType;
        this.MODEL = strainerType.model;
        this.DURABILITY = durability;
        this.LOOT_TABLE = new LootTable();
    }

    public int getMaxDamage(ItemStack stack) {
        return this.DURABILITY != null ? (Integer)this.DURABILITY.get() : 1;
    }

    public boolean func_77616_k(ItemStack strainer) {
        return this.TYPE.tier == StrainerTier.REINFORCED && (Boolean)Config.MISC_ENABLE_ENCHANTING.get() != false;
    }

    public int func_77619_b() {
        return ArmorMaterial.IRON.func_200900_a();
    }

    public boolean isBookEnchantable(ItemStack strainer, ItemStack book) {
        if (!this.func_77616_k(strainer)) {
            return false;
        }
        for (Enchantment enchantment : EnchantmentHelper.func_82781_a((ItemStack)book).keySet()) {
            if (ItemStrainer.isValidEnchantment(enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack strainer, Enchantment enchantment) {
        return ItemStrainer.isValidEnchantment(enchantment);
    }

    public static boolean isValidEnchantment(Enchantment enchantment) {
        return (Boolean)Config.MISC_ENABLE_ENCHANTING.get() != false && (enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_151370_z);
    }

    public static int getEnchantmentLevel(ItemStack strainer, Enchantment enchantment) {
        if (((Boolean)Config.MISC_ENABLE_ENCHANTING.get()).booleanValue()) {
            return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)strainer);
        }
        return 0;
    }

    public static boolean generateBonusItem(int level) {
        return level >= rand.nextInt(3) + 1;
    }

    public static boolean preventDamage(int level) {
        return level >= rand.nextInt(10) + 1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        boolean shiftPressed = GuiScreen.func_146272_n();
        if (stack.func_77984_f()) {
            int uses = stack.func_77958_k() - stack.func_77952_i();
            if (uses <= 1) {
                tooltip.add((ITextComponent)new TextComponentString("\u00a721 use left"));
            } else {
                tooltip.add((ITextComponent)new TextComponentString("\u00a72" + uses + " uses left"));
            }
        } else {
            tooltip.add((ITextComponent)new TextComponentString("\u00a72Does not break"));
        }
        if (this.TYPE.tier == StrainerTier.SOLID) {
            if ((Integer)Config.BONUS_SOLID_EFFICIENCY.get() > 0) {
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext(String.format("#GREEN#+%s%% Efficiency", Config.BONUS_SOLID_EFFICIENCY.get()))));
            }
        } else if (this.TYPE.tier == StrainerTier.REINFORCED) {
            if ((Integer)Config.BONUS_REINFORCED_EFFICIENCY.get() > 0) {
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext(String.format("#GREEN#+%s%% Efficiency", Config.BONUS_REINFORCED_EFFICIENCY.get()))));
            }
            if (((Boolean)Config.MISC_ENABLE_ENCHANTING.get()).booleanValue()) {
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext("#GREEN#+Enchantable")));
            }
        }
        if (shiftPressed || this.LOOT_TABLE.categories.size() == 0) {
            if (this.LOOT_TABLE.categories.size() > 0) {
                if (this.tooltipData.size() == 0) {
                    this.generateTooltip();
                }
                if (Math.abs(System.currentTimeMillis() - this.updateTime) > 1000L) {
                    this.updateTime = System.currentTimeMillis();
                    this.generateTooltip();
                }
                if (this.tooltipData.size() > 0) {
                    for (String t : this.tooltipData) {
                        tooltip.add((ITextComponent)new TextComponentString(t));
                    }
                }
            } else {
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext("#RED#This strainer has no valid output items and is therefore useless.")));
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext("#RED#Use the configuration files to add valid items or disable it completely.")));
                tooltip.add((ITextComponent)new TextComponentString(WaterStrainerUtils.ctext("#RED#You could also delete your loottable config to restore the default one.")));
            }
        } else {
            if (this.TYPE.category == StrainerCategory.FISHER) {
                tooltip.add((ITextComponent)new TextComponentString("Catches fish, junk and treasures."));
                tooltip.add((ITextComponent)new TextComponentString("Requires Bait."));
            } else if (this.TYPE.category == StrainerCategory.SURVIVAL) {
                tooltip.add((ITextComponent)new TextComponentString("Collects general items."));
            }
            tooltip.add((ITextComponent)new TextComponentString("Requires a Strainer Base."));
            tooltip.add((ITextComponent)new TextComponentString("\u00a77Press \u00a76shift \u00a77for more info."));
        }
    }

    private void generateTooltip() {
        this.tooltipData.clear();
        List<LootTable.Category> categories = this.LOOT_TABLE.categories;
        for (LootTable.Category cat : categories) {
            List<LootTable.Loot> lootlist = cat.items;
            int size = lootlist.size();
            if (size <= 0) continue;
            int index = this.curTooltipIndex % size;
            ItemStack lootstack = lootlist.get((int)index).stack;
            if (lootstack.func_190926_b()) continue;
            String descrString = String.format("%sx %s", lootstack.func_190916_E(), lootstack.func_200301_q().func_150254_d());
            float chance = Math.max(0.0f, 100.0f / ((float)this.LOOT_TABLE.lootTableMinIndex / (float)cat.rarity));
            descrString = String.format("%s (%.2f%%)", descrString, Float.valueOf(Math.max(0.0f, 100.0f / ((float)lootlist.get((int)(lootlist.size() - 1)).lootMaxIndex + 1.0f) * (float)lootlist.get((int)index).subRarity)));
            if (chance < 10.0f) {
                this.tooltipData.add(String.format("0%.2f%% - %s", Float.valueOf(chance), descrString));
                continue;
            }
            this.tooltipData.add(String.format("%.2f%% - %s", Float.valueOf(chance), descrString));
        }
        ++this.curTooltipIndex;
        if (this.curTooltipIndex >= 1000) {
            this.curTooltipIndex = 0;
        }
    }

    public int getEfficiencyBonus() {
        int efficiency = 0;
        if (this.TYPE.tier == StrainerTier.SOLID && (Integer)Config.BONUS_SOLID_EFFICIENCY.get() > 0) {
            efficiency += ((Integer)Config.BONUS_SOLID_EFFICIENCY.get()).intValue();
        }
        if (this.TYPE.tier == StrainerTier.REINFORCED && (Integer)Config.BONUS_REINFORCED_EFFICIENCY.get() > 0) {
            efficiency += ((Integer)Config.BONUS_REINFORCED_EFFICIENCY.get()).intValue();
        }
        return efficiency;
    }

    public static enum EnumSubtype {
        STRAINER_SURVIVALIST("strainer_survivalist", StrainerCategory.SURVIVAL, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_SURVIVALIST),
        STRAINER_SURVIVALIST_SOLID("strainer_survivalist_solid", StrainerCategory.SURVIVAL, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_SURVIVALIST_SOLID),
        STRAINER_SURVIVALIST_REINFORCED("strainer_survivalist_reinforced", StrainerCategory.SURVIVAL, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_SURVIVALIST_REINFORCED),
        STRAINER_FISHERMAN("strainer_fisherman", StrainerCategory.FISHER, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_FISHERMAN),
        STRAINER_FISHERMAN_SOLID("strainer_fisherman_solid", StrainerCategory.FISHER, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_FISHERMAN_SOLID),
        STRAINER_FISHERMAN_REINFORCED("strainer_fisherman_reinforced", StrainerCategory.FISHER, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_FISHERMAN_REINFORCED);

        public final BlockStrainerBase.Model model;
        public final StrainerCategory category;
        public final StrainerTier tier;
        public final String regname;

        private EnumSubtype(String name, StrainerCategory cat, StrainerTier tier, BlockStrainerBase.Model model) {
            this.regname = name;
            this.model = model;
            this.category = cat;
            this.tier = tier;
        }

        public static EnumSubtype getSubtype(ItemStack stack) {
            Item item = stack.func_77973_b();
            return item instanceof ItemStrainer ? ((ItemStrainer)item).TYPE : STRAINER_SURVIVALIST;
        }
    }

    public static enum StrainerTier {
        NORMAL,
        SOLID,
        REINFORCED;

    }

    public static enum StrainerCategory {
        SURVIVAL,
        FISHER;

    }
}

