/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.math.NumberUtils;

public class WaterStrainerUtils {
    public static boolean isInt(String number) {
        if (NumberUtils.isParsable((String)number)) {
            try {
                Integer.parseInt(number);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String formPlural(int number, String singular, String plural) {
        return number == 1 || number == -1 ? number + " " + singular : number + " " + plural;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy - HH:mm:ss");
        return dateFormat.format(new Date());
    }

    public static String ctext(String text) {
        text = text.replace("#PURPLE#", TextFormatting.DARK_PURPLE.toString());
        text = text.replace("#BLUE#", TextFormatting.BLUE.toString());
        text = text.replace("#RED#", TextFormatting.RED.toString());
        text = text.replace("#GREEN#", TextFormatting.DARK_GREEN.toString());
        text = text.replace("#GOLD#", TextFormatting.GOLD.toString());
        text = text.replace("#RESET#", TextFormatting.RESET.toString());
        return text + TextFormatting.RESET.toString();
    }

    public static int generateIntForChunk(World world, BlockPos pos, int range) {
        int xPosition = pos.func_177958_n() >> 4;
        int zPosition = pos.func_177952_p() >> 4;
        Random rand = new Random(world.func_72905_C() + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
        return rand.nextInt(range);
    }

    public static void sendChatMessage(ICommandSource player, String text) {
        player.func_145747_a((ITextComponent)new TextComponentString(text));
    }

    public static boolean isUsableByPlayer(EntityPlayer player, BlockPos pos) {
        return !(player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) > 64.0);
    }

    public static void dropInventoryItems(World world, BlockPos pos, IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    public static ItemStack addItemToInventory(ItemStack stack, TileEntityStrainer.InventoryHandler itemHandler, int startSlot, int endSlot) {
        if (stack != null && !stack.func_190926_b() && itemHandler != null) {
            for (int slot = startSlot; slot <= endSlot && !(stack = itemHandler.insertItem(slot, stack, false)).func_190926_b(); ++slot) {
            }
        }
        return stack;
    }

    public static void addEntityItemToInventory(EntityItem entity, TileEntityStrainer.InventoryHandler itemHandler, int startSlot, int endSlot) {
        if (entity != null && itemHandler != null) {
            ItemStack stack = WaterStrainerUtils.addItemToInventory(entity.func_92059_d().func_77946_l(), itemHandler, startSlot, endSlot);
            if (stack.func_190926_b()) {
                entity.func_70106_y();
            } else {
                entity.func_92058_a(stack);
            }
        }
    }

    public static Item getItemByName(String name) {
        return name != null && !Objects.equals(name, "$BLANK$") ? (Item)IRegistry.field_212630_s.func_212608_b(new ResourceLocation(name)) : null;
    }
}

